/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.view;

import fr.inra.sad.bagap.chloe.controller.ChloeContext;
import fr.inra.sad.bagap.chloe.controller.Controller;
import fr.inra.sad.bagap.chloe.view.ChooseTreatmentPanel;
import fr.inra.sad.bagap.chloe.view.TreatmentProgressBar;
import fr.inra.sad.bagap.chloe.view.treatment.TreatmentPanel;
import fr.inra.sad.bagap.chloe.view.wizard.Wizard;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class Ihm {
    private String version = "4.1";
    private String beta = "beta7";
    private Controller controller;
    private JFrame frame;
    private Wizard wizard;
    private TreatmentProgressBar progressBar;
    private ServerSocket socket;

    public Ihm(ServerSocket ss) {
        this.socket = ss;
    }

    public Ihm() {
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public JFrame getFrame() {
        if (this.frame == null) {
            this.frame = new JFrame();
            for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(laf.getName())) continue;
                try {
                    UIManager.setLookAndFeel(laf.getClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.frame.setSize(new Dimension(1300, 900));
            this.frame.setContentPane(this.getPanel());
            this.frame.setTitle("Chloe" + this.version + this.beta);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Ihm.this.controller.close();
                    System.exit(0);
                }
            });
            this.frame.setIconImage(Toolkit.getDefaultToolkit().getImage(ChloeContext.get().getIcon()));
            this.progressBar = new TreatmentProgressBar(this.frame);
            this.frame.setVisible(true);
        }
        return this.frame;
    }

    public Container getPanel() {
        if (this.wizard == null) {
            this.wizard = new Wizard(this.controller, this);
            this.wizard.start(new ChooseTreatmentPanel(this.wizard));
        }
        return this.wizard;
    }

    public void start() {
        this.frame.setEnabled(false);
        this.progressBar.setVisible(true);
    }

    public void resetProgressBar() {
        this.frame.setEnabled(true);
        this.progressBar.dispose();
        this.progressBar.setProgress(0);
    }

    public void reset() {
        this.resetProgressBar();
        this.wizard.previous();
    }

    public void setProgress(int progress) {
        this.progressBar.setProgress(progress);
    }

    public void publish(String text) {
        this.progressBar.publish(text);
    }

    public void message(String message) {
        this.wizard.showErrorMessage(message);
    }

    public void importTreatment() {
        JFileChooser fc = new JFileChooser(ChloeContext.get().getRepData());
        if (fc.showOpenDialog(this.frame) == 0) {
            ChloeContext.get().setRepData(fc.getSelectedFile().toString());
            String file = fc.getSelectedFile().toString();
            try {
                TreatmentPanel panel;
                Properties properties = new Properties();
                FileInputStream in = new FileInputStream(file);
                properties.load(in);
                in.close();
                String treatment = properties.getProperty("treatment");
                if (this.wizard.getCurrent().toString().equals("choose treatment")) {
                    panel = this.wizard.next(treatment);
                } else if (this.wizard.getCurrent().toString().equals(treatment)) {
                    panel = (TreatmentPanel)this.wizard.getCurrent();
                } else {
                    this.wizard.previous();
                    panel = this.wizard.next(treatment);
                }
                panel.importTreatment(file);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void exportTreatment() {
        JFileChooser fc = new JFileChooser(ChloeContext.get().getRepData());
        if (fc.showSaveDialog(this.frame) == 0) {
            ChloeContext.get().setRepData(fc.getSelectedFile().toString());
            String file = fc.getSelectedFile().toString();
            if (!file.endsWith(".properties")) {
                file = file + ".properties";
            }
            ((TreatmentPanel)this.wizard.getCurrent()).exportTreatment(file);
        }
    }
}

