/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.view;

import fr.inra.sad.bagap.chloe.controller.ChloeContext;
import fr.inra.sad.bagap.chloe.view.treatment.ClassificationPanel;
import fr.inra.sad.bagap.chloe.view.treatment.ClusterPanel;
import fr.inra.sad.bagap.chloe.view.treatment.CombinePanel;
import fr.inra.sad.bagap.chloe.view.treatment.DistancePanel;
import fr.inra.sad.bagap.chloe.view.treatment.ExportAsciiGridFromCsvPanel;
import fr.inra.sad.bagap.chloe.view.treatment.ExportAsciiGridFromShapefilePanel;
import fr.inra.sad.bagap.chloe.view.treatment.FilterPanel;
import fr.inra.sad.bagap.chloe.view.treatment.GridWindowPanel;
import fr.inra.sad.bagap.chloe.view.treatment.MapWindowPanel;
import fr.inra.sad.bagap.chloe.view.treatment.OverlayPanel;
import fr.inra.sad.bagap.chloe.view.treatment.SearchAndReplacePanel;
import fr.inra.sad.bagap.chloe.view.treatment.SelectedWindowPanel;
import fr.inra.sad.bagap.chloe.view.treatment.SlidingWindowPanel;
import fr.inra.sad.bagap.chloe.view.treatment.TreatmentPanel;
import fr.inra.sad.bagap.chloe.view.wizard.Wizard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class TreatmentTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private Wizard wizard;
    public static final int r = 255;
    public static final int g = 255;
    public static final int b = 255;

    public TreatmentTree(Wizard wizard) {
        this.wizard = wizard;
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.loadTree();
        ((DefaultTreeModel)this.getModel()).reload();
        this.expandAll();
        this.addMouseListener(this.wizard);
        this.setBackground(new Color(255, 255, 255));
        this.setFont(new Font("Verdana", 1, 13));
        this.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                ImageIcon icone = null;
                icone = node.getUserObject() instanceof TreatmentPanel ? new ImageIcon(ChloeContext.get().getRepImages() + "treatment.png") : new ImageIcon(ChloeContext.get().getRepImages() + "group.png");
                this.setBackgroundNonSelectionColor(new Color(255, 255, 255));
                this.setOpenIcon(icone);
                this.setLeafIcon(icone);
                this.setClosedIcon(icone);
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                return this;
            }
        });
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public TreatmentPanel getPanel(String treatment) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        int index = -1;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode block = (DefaultMutableTreeNode)root.getChildAt(i);
            ++index;
            for (int j = 0; j < block.getChildCount(); ++j) {
                ++index;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)block.getChildAt(j);
                if (!node.getUserObject().toString().equalsIgnoreCase(treatment)) continue;
                this.setSelectionRow(index);
                return (TreatmentPanel)node.getUserObject();
            }
        }
        throw new IllegalArgumentException(treatment);
    }

    private void loadTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        root.removeAllChildren();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("generate ascii grid");
        node.add(new DefaultMutableTreeNode(new ExportAsciiGridFromCsvPanel(this.wizard)));
        node.add(new DefaultMutableTreeNode(new ExportAsciiGridFromShapefilePanel(this.wizard)));
        root.add(node);
        node = new DefaultMutableTreeNode("util");
        node.add(new DefaultMutableTreeNode(new SearchAndReplacePanel(this.wizard)));
        node.add(new DefaultMutableTreeNode(new OverlayPanel(this.wizard)));
        node.add(new DefaultMutableTreeNode(new ClassificationPanel(this.wizard)));
        node.add(new DefaultMutableTreeNode(new CombinePanel(this.wizard)));
        node.add(new DefaultMutableTreeNode(new FilterPanel(this.wizard)));
        root.add(node);
        node = new DefaultMutableTreeNode("connectivity");
        node.add(new DefaultMutableTreeNode(new DistancePanel(this.wizard)));
        node.add(new DefaultMutableTreeNode(new ClusterPanel(this.wizard)));
        root.add(node);
        node = new DefaultMutableTreeNode("landscape metrics");
        node.add(new DefaultMutableTreeNode(new MapWindowPanel(this.wizard)));
        node.add(new DefaultMutableTreeNode(new GridWindowPanel(this.wizard)));
        node.add(new DefaultMutableTreeNode(new SlidingWindowPanel(this.wizard)));
        node.add(new DefaultMutableTreeNode(new SelectedWindowPanel(this.wizard)));
        root.add(node);
    }
}

