/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.view.distance;

import fr.inra.sad.bagap.apiland.analysis.combination.CombinationExpressionFactory;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.distance.CombinationExpressionDistanceFunction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DistanceFunctionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;

    public DistanceFunctionDialog(Frame frame, String formula, double dmax) {
        super(frame, "Distance Function", true);
        this.init(frame, formula, dmax);
        this.setVisible(true);
    }

    private void init(Window window, String formula, double dmax) {
        this.setSize(500, 300);
        int x = window.getLocation().x + window.getSize().width / 2 - this.getSize().width / 2;
        int y = window.getLocation().y + window.getSize().height / 2 - this.getSize().height / 2;
        this.setLocation(x, y);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        XYDataset dataset = this.createDataset(formula, dmax);
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        c.add((Component)chartPanel, null);
    }

    private XYDataset createDataset(String formula, double dmax) {
        if (dmax == (double)Raster.getNoDataValue()) {
            dmax = 1000.0;
        }
        CombinationExpressionDistanceFunction df = CombinationExpressionFactory.createDistanceFunction(formula, dmax);
        XYSeries series1 = new XYSeries((Comparable)((Object)"function"));
        int i = 0;
        while ((double)i < dmax) {
            series1.add((double)i, df.interprete(i));
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        return dataset;
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart((String)"distance function", (String)"distance", (String)"weight", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, true);
        renderer.setSeriesShapesVisible(0, false);
        plot.setRenderer((XYItemRenderer)renderer);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        return chart;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

