/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.view.treatment;

import fr.inra.sad.bagap.apiland.domain.AllDomain;
import fr.inra.sad.bagap.apiland.domain.BoundedDomain;
import fr.inra.sad.bagap.apiland.domain.Domain;
import fr.inra.sad.bagap.apiland.domain.NumberDomain;
import fr.inra.sad.bagap.chloe.view.treatment.TreatmentPanel;
import fr.inra.sad.bagap.chloe.view.wizard.Wizard;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ClassificationPanel
extends TreatmentPanel {
    private static final long serialVersionUID = 1L;
    private Map<Domain<Double, Double>, Integer> domains;

    public ClassificationPanel(Wizard wizard) {
        super(wizard);
    }

    @Override
    public String toString() {
        return "classification";
    }

    @Override
    protected void locateComponents() {
        title.setText("Classification");
        c = new GridBagConstraints();
        ClassificationPanel.c.insets = new Insets(5, 5, 5, 5);
        ClassificationPanel.c.gridx = 0;
        ClassificationPanel.c.gridy = 0;
        ClassificationPanel.c.gridwidth = 0;
        ClassificationPanel.c.anchor = 10;
        this.add((Component)title, c);
        ClassificationPanel.c.gridx = 0;
        ClassificationPanel.c.gridy = 1;
        ClassificationPanel.c.gridwidth = 1;
        ClassificationPanel.c.anchor = 22;
        this.add((Component)lAsciiInput, c);
        ClassificationPanel.c.gridx = 1;
        ClassificationPanel.c.gridy = 1;
        ClassificationPanel.c.gridwidth = 3;
        ClassificationPanel.c.anchor = 21;
        ClassificationPanel.c.fill = 2;
        this.add((Component)taAsciiGridInput, c);
        ClassificationPanel.c.gridx = 4;
        ClassificationPanel.c.gridy = 1;
        ClassificationPanel.c.gridwidth = 1;
        ClassificationPanel.c.anchor = 10;
        ClassificationPanel.c.fill = 0;
        ClassificationPanel.c.weightx = 0.0;
        ClassificationPanel.c.weighty = 0.0;
        this.add((Component)bAsciiGridCollectionInput, c);
        ClassificationPanel.c.gridx = 5;
        ClassificationPanel.c.gridy = 1;
        this.add((Component)bViewAsciiGridInput, c);
        ClassificationPanel.c.gridx = 0;
        ClassificationPanel.c.gridy = 3;
        ClassificationPanel.c.anchor = 24;
        this.add((Component)lClassification, c);
        ClassificationPanel.c.gridx = 1;
        ClassificationPanel.c.gridy = 3;
        ClassificationPanel.c.gridwidth = 3;
        ClassificationPanel.c.anchor = 23;
        ClassificationPanel.c.fill = 0;
        ClassificationPanel.c.weightx = 1.0;
        ClassificationPanel.c.weighty = 0.0;
        this.add((Component)pClassification, c);
        ClassificationPanel.c.gridx = 1;
        ClassificationPanel.c.gridy = 4;
        ClassificationPanel.c.gridwidth = 1;
        ClassificationPanel.c.fill = 0;
        ClassificationPanel.c.anchor = 22;
        ClassificationPanel.c.weightx = 0.0;
        ClassificationPanel.c.weighty = 0.0;
        this.add((Component)bNewClassification, c);
        ClassificationPanel.c.gridx = 2;
        ClassificationPanel.c.gridy = 4;
        ClassificationPanel.c.gridwidth = 1;
        ClassificationPanel.c.anchor = 21;
        ClassificationPanel.c.fill = 0;
        ClassificationPanel.c.weighty = 0.0;
        this.add((Component)bRemoveClassification, c);
        ClassificationPanel.c.gridx = 0;
        ClassificationPanel.c.gridy = 5;
        ClassificationPanel.c.anchor = 22;
        this.add((Component)lOutputFolder, c);
        ClassificationPanel.c.gridx = 1;
        ClassificationPanel.c.gridy = 5;
        ClassificationPanel.c.anchor = 23;
        ClassificationPanel.c.fill = 2;
        ClassificationPanel.c.weightx = 1.0;
        ClassificationPanel.c.gridwidth = 3;
        this.add((Component)taOutputFolder, c);
        ClassificationPanel.c.gridx = 4;
        ClassificationPanel.c.gridy = 5;
        ClassificationPanel.c.anchor = 19;
        ClassificationPanel.c.fill = 0;
        ClassificationPanel.c.weightx = 0.0;
        ClassificationPanel.c.gridwidth = 1;
        this.add((Component)bOutputFolder, c);
        ClassificationPanel.c.gridx = 1;
        ClassificationPanel.c.gridy = 6;
        ClassificationPanel.c.weighty = 1.0;
        ClassificationPanel.c.anchor = 23;
        ClassificationPanel.c.fill = 0;
        this.add((Component)viewAsciiOutput, c);
    }

    @Override
    public boolean validateRun(List<String> list) {
        boolean validate = true;
        if (tClassification.getModel().getRowCount() < 1) {
            list.add("Please precise at least one class");
            validate = false;
        } else {
            this.domains = new HashMap<Domain<Double, Double>, Integer>();
            for (int r = 0; r < tClassification.getModel().getRowCount(); ++r) {
                Domain<Double, Double> d = ClassificationPanel.getDomain((String)tClassification.getModel().getValueAt(r, 0));
                this.domains.put(d, Integer.parseInt((String)tClassification.getModel().getValueAt(r, 1)));
            }
        }
        if (taOutputFolder.getText().equalsIgnoreCase("")) {
            list.add("Please choose an ascci grid output matrix file");
            validate = false;
        }
        return validate;
    }

    public static Domain<Double, Double> getDomain(String value) {
        if ((value = value.replace(" ", "")).startsWith("[")) {
            if (value.endsWith("]")) {
                String[] d = value.replace("[", "").replace("]", "").replace(" ", "").split(",", 2);
                if (!d[0].equalsIgnoreCase("")) {
                    double d0 = Double.parseDouble(d[0]);
                    if (!d[1].equalsIgnoreCase("")) {
                        double d1 = Double.parseDouble(d[1]);
                        return new BoundedDomain<Double, Double>(">=", d0, "<=", d1);
                    }
                    return new NumberDomain<Double, Double>(">=", d0);
                }
                if (!d[1].equalsIgnoreCase("")) {
                    double d1 = Double.parseDouble(d[1]);
                    return new NumberDomain<Double, Double>("<=", d1);
                }
                return new AllDomain();
            }
            String[] d = value.replace("[", "").split(",", 2);
            if (!d[0].equalsIgnoreCase("")) {
                double d0 = Double.parseDouble(d[0]);
                if (!d[1].equalsIgnoreCase("")) {
                    double d1 = Double.parseDouble(d[1]);
                    return new BoundedDomain<Double, Double>(">=", d0, "<", d1);
                }
                return new NumberDomain<Double, Double>(">=", d0);
            }
            if (!d[1].equalsIgnoreCase("")) {
                double d1 = Double.parseDouble(d[1]);
                return new NumberDomain<Double, Double>("<", d1);
            }
            return new AllDomain();
        }
        if (value.endsWith("]")) {
            String[] d = value.replace("]", "").split(",", 2);
            if (!d[0].equalsIgnoreCase("")) {
                double d0 = Double.parseDouble(d[0]);
                if (!d[1].equalsIgnoreCase("")) {
                    double d1 = Double.parseDouble(d[1]);
                    return new BoundedDomain<Double, Double>(">", d0, "<=", d1);
                }
                return new NumberDomain<Double, Double>(">", d0);
            }
            if (!d[1].equalsIgnoreCase("")) {
                double d1 = Double.parseDouble(d[1]);
                return new NumberDomain<Double, Double>("<=", d1);
            }
            return new AllDomain();
        }
        String[] d = value.replace("[", "").replace("]", "").split(",", 2);
        if (!d[0].equalsIgnoreCase("")) {
            double d0 = Double.parseDouble(d[0]);
            if (!d[1].equalsIgnoreCase("")) {
                double d1 = Double.parseDouble(d[1]);
                return new BoundedDomain<Double, Double>(">", d0, "<", d1);
            }
            return new NumberDomain<Double, Double>(">", d0);
        }
        if (!d[1].equalsIgnoreCase("")) {
            double d1 = Double.parseDouble(d[1]);
            return new NumberDomain<Double, Double>("<", d1);
        }
        return new AllDomain();
    }

    @Override
    public void doImport(Properties properties) {
        this.importInputAsciiGrid(properties);
        this.importDomains(properties);
        this.importOutputFolder(properties);
        this.importVisualizeAscii(properties);
    }

    @Override
    public void doExport(Properties properties) {
        this.exportInputAsciiGrid(properties);
        this.exportDomains(properties);
        this.exportOutputFolder(properties);
        this.exportVisualizeAscii(properties);
    }

    @Override
    public void run() {
        ClassificationPanel.getController().runClassification(this, inputAsciiGrids, this.domains, taOutputFolder.getText(), viewAsciiOutput.isSelected());
    }
}

