/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.view.treatment;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.chloe.view.treatment.TreatmentPanel;
import fr.inra.sad.bagap.chloe.view.wizard.Wizard;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class GroupPanel
extends TreatmentPanel {
    private static final long serialVersionUID = 1L;
    private List<Integer> valuesClusters;
    private List<Double> minimumClusters;
    private double minimumTotal;
    private String typeCluster;
    private double distance;

    public GroupPanel(Wizard wizard) {
        super(wizard);
    }

    @Override
    public String toString() {
        return "group";
    }

    @Override
    protected void locateComponents() {
        title.setText("Group");
        c = new GridBagConstraints();
        GroupPanel.c.insets = new Insets(10, 10, 10, 10);
        GroupPanel.c.gridx = 0;
        GroupPanel.c.gridy = 0;
        GroupPanel.c.gridwidth = 0;
        GroupPanel.c.anchor = 10;
        this.add((Component)title, c);
        GroupPanel.c.gridx = 0;
        GroupPanel.c.gridy = 1;
        GroupPanel.c.gridwidth = 1;
        GroupPanel.c.anchor = 22;
        this.add((Component)lAsciiInput, c);
        GroupPanel.c.gridx = 1;
        GroupPanel.c.gridy = 1;
        GroupPanel.c.anchor = 21;
        GroupPanel.c.fill = 2;
        GroupPanel.c.weightx = 4.0;
        GroupPanel.c.gridwidth = 4;
        this.add((Component)taMatrixInput, c);
        GroupPanel.c.gridx = 5;
        GroupPanel.c.gridy = 1;
        GroupPanel.c.anchor = 10;
        GroupPanel.c.fill = 0;
        GroupPanel.c.weightx = 0.0;
        GroupPanel.c.gridwidth = 1;
        this.add((Component)bMatrixCollectionInput, c);
        GroupPanel.c.gridx = 6;
        GroupPanel.c.gridy = 1;
        this.add((Component)bViewMatrixInput, c);
        GroupPanel.c.gridx = 0;
        GroupPanel.c.gridy = 3;
        GroupPanel.c.anchor = 24;
        this.add((Component)lHabitats, c);
        GroupPanel.c.gridx = 1;
        GroupPanel.c.gridy = 3;
        GroupPanel.c.anchor = 23;
        GroupPanel.c.fill = 0;
        GroupPanel.c.weighty = 0.0;
        GroupPanel.c.gridheight = 4;
        this.add((Component)pHabitats, c);
        GroupPanel.c.gridx = 2;
        GroupPanel.c.gridy = 3;
        GroupPanel.c.gridheight = 1;
        GroupPanel.c.anchor = 23;
        this.add((Component)rbHabitatRook, c);
        GroupPanel.c.gridx = 2;
        GroupPanel.c.gridy = 4;
        this.add((Component)rbHabitatQueen, c);
        GroupPanel.c.gridx = 2;
        GroupPanel.c.gridy = 5;
        this.add((Component)rbHabitatEuclidian, c);
        GroupPanel.c.gridx = 2;
        GroupPanel.c.gridy = 6;
        this.add((Component)rbHabitatFunctional, c);
        GroupPanel.c.gridx = 1;
        GroupPanel.c.gridy = 7;
        GroupPanel.c.anchor = 22;
        this.add((Component)lFrictionCluster, c);
        GroupPanel.c.gridx = 2;
        GroupPanel.c.gridy = 7;
        GroupPanel.c.gridwidth = 3;
        GroupPanel.c.anchor = 21;
        GroupPanel.c.fill = 2;
        this.add((Component)taFrictionCluster, c);
        GroupPanel.c.gridx = 5;
        GroupPanel.c.gridy = 7;
        GroupPanel.c.gridwidth = 1;
        GroupPanel.c.anchor = 21;
        GroupPanel.c.fill = 0;
        this.add((Component)bFrictionCluster, c);
        GroupPanel.c.gridx = 1;
        GroupPanel.c.gridy = 8;
        GroupPanel.c.anchor = 22;
        this.add((Component)cbGlobalMinimumSurface, c);
        GroupPanel.c.gridx = 2;
        GroupPanel.c.gridy = 8;
        GroupPanel.c.anchor = 21;
        this.add((Component)spGlobalMinimumSurface, c);
        GroupPanel.c.gridx = 1;
        GroupPanel.c.gridy = 9;
        GroupPanel.c.anchor = 22;
        this.add((Component)cbGlobalMaximumSurface, c);
        GroupPanel.c.gridx = 2;
        GroupPanel.c.gridy = 9;
        GroupPanel.c.anchor = 21;
        this.add((Component)spGlobalMaximumSurface, c);
        GroupPanel.c.gridx = 0;
        GroupPanel.c.gridy = 10;
        GroupPanel.c.anchor = 22;
        this.add((Component)lHabitatDistance, c);
        GroupPanel.c.gridx = 1;
        GroupPanel.c.gridy = 10;
        GroupPanel.c.anchor = 21;
        this.add((Component)spHabitatDistance, c);
        GroupPanel.c.gridx = 0;
        GroupPanel.c.gridy = 12;
        GroupPanel.c.anchor = 24;
        this.add((Component)lComplementaries, c);
        GroupPanel.c.gridx = 1;
        GroupPanel.c.gridy = 12;
        GroupPanel.c.anchor = 23;
        GroupPanel.c.fill = 0;
        GroupPanel.c.weighty = 0.0;
        GroupPanel.c.gridheight = 4;
        this.add((Component)pComplementaries, c);
        GroupPanel.c.gridx = 0;
        GroupPanel.c.gridy = 20;
        GroupPanel.c.gridheight = 1;
        GroupPanel.c.anchor = 22;
        this.add((Component)lOutputFolder, c);
        GroupPanel.c.gridx = 1;
        GroupPanel.c.gridy = 20;
        GroupPanel.c.anchor = 23;
        GroupPanel.c.fill = 2;
        GroupPanel.c.weightx = 1.0;
        GroupPanel.c.gridwidth = 4;
        this.add((Component)taOutputFolder, c);
        GroupPanel.c.gridx = 5;
        GroupPanel.c.gridy = 20;
        GroupPanel.c.anchor = 19;
        GroupPanel.c.fill = 0;
        GroupPanel.c.weightx = 0.0;
        GroupPanel.c.gridwidth = 1;
        this.add((Component)bOutputFolder, c);
        GroupPanel.c.gridx = 1;
        GroupPanel.c.gridy = 21;
        GroupPanel.c.weightx = 0.0;
        GroupPanel.c.weighty = 1.0;
        GroupPanel.c.anchor = 23;
        GroupPanel.c.fill = 0;
        this.add((Component)viewAsciiOutput, c);
    }

    @Override
    public boolean validateRun(List<String> list) {
        boolean validate = true;
        this.valuesClusters = new ArrayList<Integer>();
        this.minimumClusters = new ArrayList<Double>();
        for (int r : tDistances.getSelectedRows()) {
            this.valuesClusters.add((Integer)tDistances.getModel().getValueAt(r, 0));
            this.minimumClusters.add(0.0);
        }
        this.minimumTotal = 0.0;
        if (rbRook.isSelected()) {
            this.typeCluster = "rook";
        } else if (rbQueen.isSelected()) {
            this.typeCluster = "queen";
        } else if (rbEuclidianCluster.isSelected()) {
            this.typeCluster = "euclidian";
            this.distance = (Double)spEuclidianCluster.getValue();
        } else {
            this.typeCluster = "functional";
            this.distance = (Double)spFunctionalCluster.getValue();
            if (clusterFrictionMatrix.size() == 0) {
                clusterFriction = new Friction(taFrictionCluster.getText());
            }
        }
        if (taOutputFolder.getText().equalsIgnoreCase("")) {
            list.add("Please choose an ascci grid output matrix file");
            validate = false;
        }
        return validate;
    }

    @Override
    public void doImport(Properties properties) {
        this.importInputMatrix(properties);
        this.importCluster(properties);
        this.importClusterType(properties);
        this.importClusterDistance(properties);
        this.importClusterFriction(properties);
        this.importClusterFrictionMatrix(properties);
        this.importOutputFolder(properties);
        this.importVisualizeAscii(properties);
    }

    @Override
    public void doExport(Properties properties) {
        this.exportInputMatrix(properties);
        this.exportCluster(properties);
        this.exportClusterType(properties);
        this.exportClusterDistance(properties);
        this.exportClusterFriction(properties);
        this.exportClusterFrictionMatrix(properties);
        this.exportOutputFolder(properties);
        this.exportVisualizeAscii(properties);
    }

    @Override
    public void run() {
        GroupPanel.getController().runGroup(inputMatrix, this.valuesClusters, this.minimumClusters, this.minimumTotal, this.typeCluster, this.distance, clusterFriction, clusterFrictionMatrix.size() == 0 ? null : (Matrix)clusterFrictionMatrix.iterator().next(), taOutputFolder.getText(), viewAsciiOutput.isSelected());
    }
}

