/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.agriconnect.model.metric;

import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ConnectivityMetric
extends VectorMetric {
    private Object code;

    public ConnectivityMetric(Object code) {
        super(VariableManager.get("C_" + code));
        this.code = code;
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        this.value = 0.0;
        int nb = 0;
        if (this.code instanceof CoverGroup) {
            for (Polygon p : polygons) {
                if (!((Composition)p.getUserData()).getAttribute("cover").isActive(t) || !((CoverGroup)this.code).contains((Cover)((Composition)p.getUserData()).getAttribute("cover").getValue(t))) continue;
                ++nb;
                this.value += Math.exp(-(point.distance((Geometry)p) / 1000.0)) * (p.getArea() / 10000.0);
            }
            this.value /= (double)nb;
        } else {
            for (Polygon p : polygons) {
                if (!((Composition)p.getUserData()).getAttribute("cover").isActive(t) || !((Composition)p.getUserData()).getAttribute("cover").getValue(t).equals(this.code)) continue;
                ++nb;
                this.value += Math.exp(-(point.distance((Geometry)p) / 1000.0)) * (p.getArea() / 10000.0);
            }
            this.value /= (double)nb;
        }
        if (Double.isNaN(this.value)) {
            this.value = Raster.getNoDataValue();
        }
    }
}

