/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.agriconnect.model.metric;

import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class HanskiConnectivityMetric
extends VectorMetric {
    private Object code;
    private int index = 0;

    public HanskiConnectivityMetric(Object code) {
        super(VariableManager.get("HC_" + code));
        this.code = code;
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        this.value = 0.0;
        int nb = 0;
        if (this.code instanceof CoverGroup) {
            for (Polygon p1 : polygons) {
                if (!((Composition)p1.getUserData()).getAttribute("cover").isActive(t) || !((CoverGroup)this.code).contains((Cover)((Composition)p1.getUserData()).getAttribute("cover").getValue(t))) continue;
                ++nb;
                for (Polygon p2 : polygons) {
                    if (p1.equals((Geometry)p2) || !((Composition)p2.getUserData()).getAttribute("cover").isActive(t) || !((CoverGroup)this.code).contains((Cover)((Composition)p2.getUserData()).getAttribute("cover").getValue(t))) continue;
                    this.value += Math.exp(-(p1.distance((Geometry)p2) / 1000.0)) * (p2.getArea() / 10000.0);
                }
            }
            this.value /= (double)nb;
            System.out.println("vecteur " + this.index++ + ": value = " + this.value + " (" + nb + ")");
        } else {
            for (Polygon p1 : polygons) {
                if (!((Composition)p1.getUserData()).getAttribute("cover").isActive(t) || !((Composition)p1.getUserData()).getAttribute("cover").getValue(t).equals(this.code)) continue;
                ++nb;
                for (Polygon p2 : polygons) {
                    if (p1.equals((Geometry)p2) || !((Composition)p2.getUserData()).getAttribute("cover").isActive(t) || !((Composition)p2.getUserData()).getAttribute("cover").getValue(t).equals(this.code)) continue;
                    this.value += Math.exp(-(p1.distance((Geometry)p2) / 1000.0)) * (p2.getArea() / 10000.0);
                }
            }
            this.value /= (double)nb;
            System.out.println("vecteur : value = " + this.value + " (" + nb + ")");
        }
        if (Double.isNaN(this.value)) {
            this.value = Raster.getNoDataValue();
        }
    }
}

