/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.combination;

import fr.inra.sad.bagap.apiland.analysis.combination.CombinationBaseListener;
import fr.inra.sad.bagap.apiland.analysis.combination.CombinationParser;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.AndCombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.CombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.ConditionCombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.EqualZeroCombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.InfEqualZeroCombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.InfZeroCombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.NegativeCombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.NotZeroCombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.OrCombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.SimpleCombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.SupEqualZeroCombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.SupZeroCombinationExpression;
import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.misc.NotNull;

public class CombinationExpressionBuilder
extends CombinationBaseListener {
    private Set<String> localNames = new HashSet<String>();
    private CombinationExpression expression;
    private String boolExpression;
    private String boolOp;

    public CombinationExpression build() {
        return this.expression;
    }

    private void addCombinationExpression(CombinationExpression ce) {
        if (this.expression == null) {
            this.expression = ce;
        } else {
            this.expression.addCombinationExpression(ce);
        }
    }

    @Override
    public void enterConditional(@NotNull CombinationParser.ConditionalContext ctx) {
        this.addCombinationExpression(new ConditionCombinationExpression());
    }

    @Override
    public void enterName(@NotNull CombinationParser.NameContext ctx) {
        this.localNames.add(ctx.getText());
    }

    @Override
    public void exitBloc(@NotNull CombinationParser.BlocContext ctx) {
        this.addCombinationExpression(new SimpleCombinationExpression(ctx.getText(), this.localNames.toArray(new String[this.localNames.size()])));
        this.localNames.clear();
    }

    @Override
    public void exitLeftoperation(@NotNull CombinationParser.LeftoperationContext ctx) {
        this.boolExpression = ctx.getText();
    }

    @Override
    public void enterBoolop(@NotNull CombinationParser.BoolopContext ctx) {
        this.boolOp = ctx.getText();
    }

    @Override
    public void exitRightoperation(@NotNull CombinationParser.RightoperationContext ctx) {
        this.boolExpression = this.boolExpression + "-" + ctx.getText();
    }

    @Override
    public void exitBoolterm(@NotNull CombinationParser.BooltermContext ctx) {
        switch (this.boolOp) {
            case ">": {
                this.addCombinationExpression(new SupZeroCombinationExpression(this.boolExpression, this.localNames.toArray(new String[this.localNames.size()])));
                break;
            }
            case "<": {
                this.addCombinationExpression(new InfZeroCombinationExpression(this.boolExpression, this.localNames.toArray(new String[this.localNames.size()])));
                break;
            }
            case ">=": {
                this.addCombinationExpression(new SupEqualZeroCombinationExpression(this.boolExpression, this.localNames.toArray(new String[this.localNames.size()])));
                break;
            }
            case "<=": {
                this.addCombinationExpression(new InfEqualZeroCombinationExpression(this.boolExpression, this.localNames.toArray(new String[this.localNames.size()])));
                break;
            }
            case "==": {
                this.addCombinationExpression(new EqualZeroCombinationExpression(this.boolExpression, this.localNames.toArray(new String[this.localNames.size()])));
                break;
            }
            case "!=": {
                this.addCombinationExpression(new NotZeroCombinationExpression(this.boolExpression, this.localNames.toArray(new String[this.localNames.size()])));
                break;
            }
            default: {
                throw new IllegalArgumentException(this.boolOp);
            }
        }
    }

    @Override
    public void enterBooltermnegation(@NotNull CombinationParser.BooltermnegationContext ctx) {
        this.addCombinationExpression(new NegativeCombinationExpression());
    }

    @Override
    public void enterAndgenericboolterm(@NotNull CombinationParser.AndgenericbooltermContext ctx) {
        this.addCombinationExpression(new AndCombinationExpression(ctx.genericboolterm().size()));
    }

    @Override
    public void enterOrgenericboolterm(@NotNull CombinationParser.OrgenericbooltermContext ctx) {
        this.addCombinationExpression(new OrCombinationExpression(ctx.genericboolterm().size()));
    }
}

