/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.combination.expression;

import fr.inra.sad.bagap.apiland.analysis.combination.expression.BooleanCombinationExpression;
import fr.inra.sad.bagap.apiland.analysis.combination.expression.CombinationExpression;

public class ConditionCombinationExpression
implements CombinationExpression {
    private BooleanCombinationExpression booleanExpression;
    protected CombinationExpression trueExpression;
    protected CombinationExpression falseExpression;

    public String toString() {
        return this.trueExpression + " " + this.falseExpression;
    }

    protected CombinationExpression getTrueExpression() {
        return this.trueExpression;
    }

    protected CombinationExpression getFalseExpression() {
        return this.falseExpression;
    }

    @Override
    public double evaluate() {
        if (this.booleanExpression.evaluation()) {
            return this.trueExpression.evaluate();
        }
        return this.falseExpression.evaluate();
    }

    @Override
    public void setValue(String name, double value) {
        this.booleanExpression.setValue(name, value);
        if (this.trueExpression != null) {
            this.trueExpression.setValue(name, value);
        }
        if (this.falseExpression != null) {
            this.falseExpression.setValue(name, value);
        }
    }

    @Override
    public boolean addCombinationExpression(CombinationExpression ce) {
        if (this.booleanExpression == null) {
            this.booleanExpression = (BooleanCombinationExpression)ce;
            return true;
        }
        if (this.booleanExpression.addCombinationExpression(ce)) {
            return true;
        }
        if (this.trueExpression == null) {
            this.trueExpression = ce;
            return true;
        }
        if (this.trueExpression.addCombinationExpression(ce)) {
            return true;
        }
        if (this.falseExpression == null) {
            this.falseExpression = ce;
            return true;
        }
        return this.falseExpression.addCombinationExpression(ce);
    }

    @Override
    public void init() {
        this.booleanExpression.init();
        if (this.trueExpression != null) {
            this.trueExpression.init();
        }
        if (this.falseExpression != null) {
            this.falseExpression.init();
        }
    }
}

