/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.combination.expression;

import fr.inra.sad.bagap.apiland.analysis.combination.expression.CombinationExpression;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.util.Set;
import java.util.TreeSet;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public class SimpleCombinationExpression
implements CombinationExpression {
    private String exp;
    private Set<String> names;
    private Expression expression;
    private boolean hasnodata;

    public SimpleCombinationExpression(String exp, String ... names) {
        this.exp = exp;
        this.names = new TreeSet<String>();
        for (String name : names) {
            this.names.add(name);
        }
        this.hasnodata = false;
        this.expression = new ExpressionBuilder(exp).variables(names).build();
    }

    public String toString() {
        return this.exp;
    }

    protected Expression getExpression() {
        return this.expression;
    }

    @Override
    public void setValue(String name, double value) {
        if (this.names.contains(name)) {
            if (value == (double)Raster.getNoDataValue()) {
                this.hasnodata = true;
            }
            this.expression.setVariable(name, value);
        }
    }

    @Override
    public double evaluate() {
        try {
            if (!this.hasnodata) {
                return this.expression.evaluate();
            }
            this.hasnodata = false;
            return Raster.getNoDataValue();
        }
        catch (ArithmeticException e) {
            return Raster.getNoDataValue();
        }
    }

    @Override
    public boolean addCombinationExpression(CombinationExpression ce) {
        return false;
    }

    @Override
    public void init() {
        this.hasnodata = false;
    }
}

