/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArrayRCMDistanceAnalysis
extends Analysis {
    private float[] outDatas;
    private float[] frictionDatas;
    private double threshold;
    private int width;
    private int height;
    private float cellSize;
    private Map<Float, Set<Pixel>> waits;

    public ArrayRCMDistanceAnalysis(float[] outDatas, float[] frictionDatas, int width, int height, float cellSize, Map<Float, Set<Pixel>> waits) {
        this(outDatas, frictionDatas, width, height, cellSize, waits, Raster.getNoDataValue());
    }

    public ArrayRCMDistanceAnalysis(float[] outDatas, float[] frictionDatas, int width, int height, float cellSize, Map<Float, Set<Pixel>> waits, double threshold) {
        this.outDatas = outDatas;
        this.frictionDatas = frictionDatas;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.waits = waits;
        this.threshold = threshold == (double)Raster.getNoDataValue() ? 2.147483647E9 : threshold;
    }

    @Override
    protected void doInit() {
    }

    @Override
    public void doRun() {
        while (this.waits.size() > 0) {
            this.diffusionPaquet();
        }
        this.setResult(this.outDatas);
    }

    private void setPixelAndValue(Map<Float, Set<Pixel>> waits, Pixel pixel, float value) {
        if (!waits.containsKey(Float.valueOf(value))) {
            waits.put(Float.valueOf(value), new HashSet());
        }
        waits.get(Float.valueOf(value)).add(pixel);
    }

    private void diffusionPaquet() {
        Iterator<Map.Entry<Float, Set<Pixel>>> iteEntry = this.waits.entrySet().iterator();
        Map.Entry<Float, Set<Pixel>> entry = iteEntry.next();
        iteEntry.remove();
        if (entry.getValue().size() != 0) {
            double dd = entry.getKey().floatValue();
            Iterator<Pixel> itePixel = entry.getValue().iterator();
            while (itePixel.hasNext()) {
                Pixel p = itePixel.next();
                itePixel.remove();
                this.diffusion(p, dd);
            }
        }
    }

    private void diffusion(Pixel p, double dd) {
        double vd;
        if (this.threshold > dd && (vd = (double)this.outDatas[p.x() + p.y() * this.width]) != (double)Raster.getNoDataValue()) {
            float d;
            float fc;
            float v;
            Pixel np;
            double fd = this.frictionDatas[p.x() + p.y() * this.width];
            Iterator<Pixel> ite = p.getCardinalMargins();
            while (ite.hasNext()) {
                np = ite.next();
                if (np.x() < 0 || np.x() >= this.width || np.y() < 0 || np.y() >= this.height || (v = this.outDatas[np.x() + np.y() * this.width]) == (float)Raster.getNoDataValue()) continue;
                fc = this.frictionDatas[np.x() + np.y() * this.width];
                d = (float)(dd + (double)(this.cellSize / 2.0f) * fd + (double)(this.cellSize / 2.0f * fc));
                if (v != -2.0f && !(d < v)) continue;
                this.outDatas[np.x() + np.y() * this.width] = d;
                this.setPixelAndValue(this.waits, np, d);
            }
            ite = p.getDiagonalMargins();
            while (ite.hasNext()) {
                np = ite.next();
                if (np.x() < 0 || np.x() >= this.width || np.y() < 0 || np.y() >= this.height || (v = this.outDatas[np.x() + np.y() * this.width]) == (float)Raster.getNoDataValue()) continue;
                fc = this.frictionDatas[np.x() + np.y() * this.width];
                d = (float)(dd + (double)this.cellSize * Math.sqrt(2.0) / 2.0 * fd + (double)this.cellSize * Math.sqrt(2.0) / 2.0 * (double)fc);
                if (v != -2.0f && !(d < v)) continue;
                this.outDatas[np.x() + np.y() * this.width] = d;
                this.setPixelAndValue(this.waits, np, d);
            }
        }
    }

    @Override
    protected void doClose() {
    }
}

