/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;

public class ChamferDistanceTabAnalysis
extends Analysis {
    private static final int[][] chamfer13 = new int[][]{{1, 0, 68}, {1, 1, 96}, {2, 1, 152}, {3, 1, 215}, {3, 2, 245}, {4, 1, 280}, {4, 3, 340}, {5, 1, 346}, {6, 1, 413}};
    private float[] input;
    private float[] output;
    private int width;
    private int height;
    private float cellSize;
    private int[][] chamfer = chamfer13;
    private int normalizer = this.chamfer[0][2];
    private int[] codes;
    private float threshold;

    public ChamferDistanceTabAnalysis(float[] output, float[] input, int width, int height, float cellSize, int[] codes) {
        this(output, input, width, height, cellSize, codes, Raster.getNoDataValue());
    }

    public ChamferDistanceTabAnalysis(float[] output, float[] input, int width, int height, float cellSize, int[] codes, float threshold) {
        this.output = output;
        this.input = input;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.codes = codes;
        this.threshold = threshold;
    }

    private void testAndSet(float[] output, int x, int y, float newvalue) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        double v = output[y * this.width + x];
        if (v >= 0.0 && v < (double)newvalue) {
            return;
        }
        output[y * this.width + x] = newvalue;
    }

    @Override
    protected void doRun() {
        int dt;
        int dx;
        int k;
        int x;
        int y;
        boolean hasCode = false;
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                double v = this.input[y * this.width + x];
                boolean ok = false;
                if (v != (double)Raster.getNoDataValue()) {
                    for (int c : this.codes) {
                        if ((double)c != v) continue;
                        ok = true;
                        hasCode = true;
                        break;
                    }
                }
                this.output[y * this.width + x] = ok ? 0.0f : (float)Raster.getNoDataValue();
            }
        }
        if (!hasCode) {
            this.setResult(this.output);
            return;
        }
        for (y = 0; y <= this.height - 1; ++y) {
            for (x = 0; x <= this.width - 1; ++x) {
                float v = this.output[y * this.width + x];
                if (v == (float)Raster.getNoDataValue()) continue;
                for (k = 0; k < this.chamfer.length; ++k) {
                    dx = this.chamfer[k][0];
                    int dy = this.chamfer[k][1];
                    dt = this.chamfer[k][2];
                    this.testAndSet(this.output, x + dx, y + dy, v + (float)dt);
                    if (dy != 0) {
                        this.testAndSet(this.output, x - dx, y + dy, v + (float)dt);
                    }
                    if (dx == dy) continue;
                    this.testAndSet(this.output, x + dy, y + dx, v + (float)dt);
                    if (dy == 0) continue;
                    this.testAndSet(this.output, x - dy, y + dx, v + (float)dt);
                }
            }
        }
        for (y = this.height - 1; y >= 0; --y) {
            for (x = this.width - 1; x >= 0; --x) {
                float v = this.output[y * this.width + x];
                if (v == (float)Raster.getNoDataValue()) continue;
                for (k = 0; k < this.chamfer.length; ++k) {
                    dx = this.chamfer[k][0];
                    int dy = this.chamfer[k][1];
                    dt = this.chamfer[k][2];
                    this.testAndSet(this.output, x - dx, y - dy, v + (float)dt);
                    if (dy != 0) {
                        this.testAndSet(this.output, x + dx, y - dy, v + (float)dt);
                    }
                    if (dx == dy) continue;
                    this.testAndSet(this.output, x - dy, y - dx, v + (float)dt);
                    if (dy == 0) continue;
                    this.testAndSet(this.output, x + dy, y - dx, v + (float)dt);
                }
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                float v = this.output[y * this.width + x];
                if (v == (float)Raster.getNoDataValue()) continue;
                this.output[y * this.width + x] = v / (float)this.normalizer * this.cellSize;
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                double v = this.input[y * this.width + x];
                if (v == (double)Raster.getNoDataValue()) {
                    this.output[y * this.width + x] = Raster.getNoDataValue();
                    continue;
                }
                double v2 = this.output[y * this.width + x];
                if (this.threshold == (float)Raster.getNoDataValue() || !(v2 > (double)this.threshold)) continue;
                this.output[y * this.width + x] = this.threshold;
            }
        }
        this.setResult(this.output);
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doClose() {
    }
}

