/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class EuclidianDistanceCalculation
extends MatrixCalculation {
    private RasterComposite sources;
    private int[] cat;

    public EuclidianDistanceCalculation(Matrix m, RasterComposite rc, int ... cat) {
        super(m);
        this.sources = rc;
        this.cat = cat;
    }

    @Override
    public void doInit() {
    }

    @Override
    public void doRun() {
        Matrix dist = MatrixFactory.get(this.matrix().getType()).create(this.matrix());
        dist.init(999999.0);
        RasterComposite rc = new RasterComposite();
        block0: for (Raster r : this.sources.getRasters()) {
            int v = (int)this.matrix().get(r.getOne());
            for (int c : this.cat) {
                if (v != c) continue;
                for (Pixel p : r) {
                    dist.put(p, 0.0);
                }
                rc.addSimplePixelComposite((PixelComposite)r);
                continue block0;
            }
        }
        HashMap<Pixel, Double> waits = new HashMap<Pixel, Double>();
        GComparator pComparator = new GComparator(waits);
        LinkedList<Pixel> wp = new LinkedList<Pixel>();
        for (Raster r : rc) {
            Iterator<Pixel> ite = r.getBoundaries();
            while (ite.hasNext()) {
                Pixel p = ite.next();
                waits.put(p, 0.0);
                wp.add(p);
            }
        }
        while (waits.size() > 0) {
            this.euclidianDiffusion(this.matrix(), dist, waits, pComparator, wp);
        }
        this.setResult(dist);
    }

    private void euclidianDiffusion(Matrix m, Matrix dist, Map<Pixel, Double> waits, GComparator pComparator, LinkedList<Pixel> wp) {
        double v;
        Pixel np;
        Collections.sort(wp, pComparator);
        Pixel p = wp.poll();
        double d = waits.remove(p);
        Iterator<Pixel> ite = p.getCardinalMargins();
        while (ite.hasNext()) {
            np = ite.next();
            v = d + m.cellsize();
            if (!(v < dist.get(np))) continue;
            dist.put(np, v);
            if (!waits.containsKey(np)) {
                wp.addLast(np);
            }
            waits.put(np, v);
        }
        ite = p.getDiagonalMargins();
        while (ite.hasNext()) {
            np = ite.next();
            v = d + m.cellsize() * Math.sqrt(2.0);
            if (!(v < dist.get(np))) continue;
            dist.put(np, v);
            if (!waits.containsKey(np)) {
                wp.addLast(np);
            }
            waits.put(np, v);
        }
    }

    @Override
    public void doClose() {
        this.sources = null;
    }

    private class GComparator<G>
    implements Comparator<G> {
        private Map<G, Double> w;

        public GComparator(Map<G, Double> w) {
            this.w = w;
        }

        @Override
        public int compare(G g1, G g2) {
            return this.w.get(g1).compareTo(this.w.get(g2));
        }
    }
}

