/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.ArrayRCMDistanceAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.CoverageManager;
import fr.inra.sad.bagap.apiland.core.element.manager.Tool;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.image.util.ImageUtilities;

public class HugeRCMDistanceAnalysis
extends Analysis {
    private String input;
    private String inputFriction;
    private String output;
    private String temp;
    private int[] codes;
    private GridCoverage2D inCoverage;
    private GridCoverage2D frictionCoverage;
    private float threshold;
    private int maxTile = 15000;
    private Map<Pixel, Map<String, float[]>> bords;
    private int width;
    private int height;
    private double imageMinX;
    private double imageMinY;
    private double imageMaxX;
    private double imageMaxY;
    private float cellSize;
    private int dWidth;
    private int dHeight;
    private short[] calculTab;
    private short[] majTab;

    public static void main(String[] args) {
        String input = "F:/chloe/debug/mallet/Habitat_et_permeabilite/Habitat_haie_sup_0_mas_clean.asc";
        String inputFriction = "F:/chloe/debug/mallet/Habitat_et_permeabilite/Permeabilite_grand_rhino_bis.asc";
        String output = "F:/chloe/debug/mallet/Habitat_et_permeabilite/continuites_bis.asc";
        HashSet<Integer> c = new HashSet<Integer>();
        c.add(1);
        Raster.setNoDataValue(-1);
        new HugeRCMDistanceAnalysis(input, inputFriction, output, c).allRun();
    }

    public HugeRCMDistanceAnalysis(String input, String inputFriction, String output, Collection<Integer> codes) {
        this(input, inputFriction, output, codes, Raster.getNoDataValue());
    }

    public HugeRCMDistanceAnalysis(String input, String inputFriction, String output, Collection<Integer> codes, float threshold) {
        this.input = input;
        this.inputFriction = inputFriction;
        this.output = output;
        this.temp = Tool.deleteExtension(output);
        this.codes = new int[codes.size()];
        int index = 0;
        for (int i : codes) {
            this.codes[index++] = i;
        }
        this.threshold = threshold;
    }

    @Override
    protected void doInit() {
        this.inCoverage = CoverageManager.get(this.input);
        this.width = (Integer)this.inCoverage.getProperty("image_width");
        this.height = (Integer)this.inCoverage.getProperty("image_height");
        this.imageMinX = this.inCoverage.getEnvelope().getMinimum(0);
        this.imageMinY = this.inCoverage.getEnvelope().getMinimum(1);
        this.imageMaxX = this.inCoverage.getEnvelope().getMaximum(0);
        this.imageMaxY = this.inCoverage.getEnvelope().getMaximum(1);
        this.cellSize = (float)((AffineTransform)this.inCoverage.getGridGeometry().getGridToCRS2D()).getScaleX();
        this.frictionCoverage = CoverageManager.get(this.inputFriction);
        this.dWidth = 0;
        this.dHeight = 0;
        this.bords = new HashMap<Pixel, Map<String, float[]>>();
        int dx = 0;
        int dy = 0;
        for (int y = 0; y < this.height; y += this.maxTile - 1) {
            dx = 0;
            this.dWidth = 0;
            for (int x = 0; x < this.width; x += this.maxTile - 1) {
                float[] bord;
                ++this.dWidth;
                Pixel p = new Pixel(dx, dy);
                this.bords.put(p, new HashMap());
                int roiWidth = Math.min(this.maxTile, this.width - x);
                int roiHeight = Math.min(this.maxTile, this.height - y);
                if (dx > 0) {
                    bord = new float[roiHeight];
                    Arrays.fill(bord, -1.0f);
                    this.bords.get(p).put("left", bord);
                    this.bords.get(new Pixel(dx - 1, dy)).put("right", bord);
                }
                if (dy > 0) {
                    bord = new float[roiWidth];
                    Arrays.fill(bord, -1.0f);
                    this.bords.get(p).put("north", bord);
                    this.bords.get(new Pixel(dx, dy - 1)).put("south", bord);
                }
                ++dx;
            }
            ++this.dHeight;
            ++dy;
        }
        this.calculTab = new short[this.dWidth * this.dHeight];
        Arrays.fill(this.calculTab, (short)-1);
        this.majTab = new short[this.dWidth * this.dHeight];
        Arrays.fill(this.majTab, (short)0);
    }

    @Override
    protected void doRun() {
        boolean finish = false;
        int pass = 1;
        while (!finish) {
            TreeMap<Float, Set<Pixel>> waits;
            double roiPosMaxY;
            double roiPosMinY;
            double roiPosMaxX;
            double roiPosMinX;
            int roiHeight;
            int roiWidth;
            int x;
            int y;
            int dy;
            int dx;
            finish = true;
            System.out.println("pass " + pass);
            if (pass == 1) {
                dx = 0;
                dy = 0;
                for (y = 0; y < this.height; y += this.maxTile - 1) {
                    dx = 0;
                    for (x = 0; x < this.width; x += this.maxTile - 1) {
                        System.out.println("traitement de la tuile " + dx + " " + dy + " / " + this.dWidth + " " + this.dHeight);
                        roiWidth = Math.min(this.maxTile, this.width - x);
                        roiHeight = Math.min(this.maxTile, this.height - y);
                        roiPosMinX = this.imageMinX + (double)((float)x * this.cellSize);
                        roiPosMaxX = roiPosMinX + (double)((float)roiWidth * this.cellSize);
                        roiPosMinY = Math.max(this.imageMinY, this.imageMaxY - (double)((float)(y + roiHeight) * this.cellSize));
                        roiPosMaxY = roiPosMinY + (double)((float)roiHeight * this.cellSize);
                        float[] inDatas = CoverageManager.getData(this.inCoverage, x, y, roiWidth, roiHeight);
                        float[] frictionDatas = CoverageManager.getData(this.frictionCoverage, x, y, roiWidth, roiHeight);
                        float[] outDatas = new float[roiHeight * roiWidth];
                        boolean hasValue = false;
                        for (int yt = 0; yt < roiHeight; ++yt) {
                            for (int xt = 0; xt < roiWidth; ++xt) {
                                float v = inDatas[yt * roiWidth + xt];
                                boolean ok = false;
                                if (v != (float)Raster.getNoDataValue()) {
                                    for (int c : this.codes) {
                                        if ((float)c != v) continue;
                                        ok = true;
                                        hasValue = true;
                                        break;
                                    }
                                    if (ok) {
                                        outDatas[yt * roiWidth + xt] = 0.0f;
                                        continue;
                                    }
                                    outDatas[yt * roiWidth + xt] = -2.0f;
                                    continue;
                                }
                                outDatas[yt * roiWidth + xt] = Raster.getNoDataValue();
                            }
                        }
                        waits = new TreeMap<Float, Set<Pixel>>();
                        for (int yt = 0; yt < roiHeight; ++yt) {
                            for (int xt = 0; xt < roiWidth; ++xt) {
                                if (outDatas[yt * roiWidth + xt] != 0.0f) continue;
                                boolean maj = true;
                                if (!(xt != 0 && outDatas[xt - 1 + yt * roiWidth] != 0.0f || xt != 0 && yt != 0 && outDatas[xt - 1 + (yt - 1) * roiWidth] != 0.0f || yt != 0 && outDatas[xt + (yt - 1) * roiWidth] != 0.0f || xt != roiWidth - 1 && yt != 0 && outDatas[xt + 1 + (yt - 1) * roiWidth] != 0.0f || xt != roiWidth - 1 && outDatas[xt + 1 + yt * roiWidth] != 0.0f || xt != roiWidth - 1 && yt != roiHeight - 1 && outDatas[xt + 1 + (yt + 1) * roiWidth] != 0.0f || yt != roiHeight - 1 && outDatas[xt + (yt + 1) * roiWidth] != 0.0f || xt != 0 && yt != roiHeight - 1 && outDatas[xt - 1 + (yt + 1) * roiWidth] != 0.0f)) {
                                    maj = false;
                                }
                                if (!maj) continue;
                                this.setPixelAndValue(waits, new Pixel(xt, yt), 0.0f);
                            }
                        }
                        if (hasValue) {
                            ArrayRCMDistanceAnalysis rcm = new ArrayRCMDistanceAnalysis(outDatas, frictionDatas, roiWidth, roiHeight, this.cellSize, waits);
                            boolean isFinish = this.bordUpdateFromData(dx, dy, roiWidth, roiHeight, roiPosMinX, roiPosMaxX, roiPosMinY, roiPosMaxY, outDatas = (float[])rcm.allRun());
                            if (!isFinish) {
                                finish = false;
                            }
                            this.calculTab[dy * this.dWidth + dx] = 1;
                        }
                        CoverageManager.writeGeotiff(new File(this.temp + "_" + dx + "-" + dy + ".tif"), outDatas, roiWidth, roiHeight, roiPosMinX, roiPosMaxX, roiPosMinY, roiPosMaxY);
                        ++dx;
                    }
                    ++dy;
                }
            } else {
                if (this.inCoverage != null) {
                    this.inCoverage.dispose(true);
                    PlanarImage planarImage = (PlanarImage)this.inCoverage.getRenderedImage();
                    ImageUtilities.disposePlanarImageChain((PlanarImage)planarImage);
                    this.inCoverage = null;
                }
                dx = 0;
                dy = 0;
                for (y = 0; y < this.height; y += this.maxTile - 1) {
                    dx = 0;
                    for (x = 0; x < this.width; x += this.maxTile - 1) {
                        if (this.majTab[dy * this.dWidth + dx] == 1) {
                            float[] frictionDatas;
                            ArrayRCMDistanceAnalysis ccd;
                            boolean isFinish;
                            float[] bord;
                            System.out.println("traitement de la tuile " + dx + " " + dy + " / " + this.dWidth + " " + this.dHeight);
                            roiWidth = Math.min(this.maxTile, this.width - x);
                            roiHeight = Math.min(this.maxTile, this.height - y);
                            roiPosMinX = this.imageMinX + (double)((float)x * this.cellSize);
                            roiPosMaxX = roiPosMinX + (double)((float)roiWidth * this.cellSize);
                            roiPosMinY = Math.max(this.imageMinY, this.imageMaxY - (double)((float)(y + roiHeight) * this.cellSize));
                            roiPosMaxY = roiPosMinY + (double)((float)roiHeight * this.cellSize);
                            GridCoverage2D cov = CoverageManager.get(this.temp + "_" + dx + "-" + dy + ".tif");
                            float[] outDatas = CoverageManager.getData(cov, 0, 0, roiWidth, roiHeight);
                            cov.dispose(true);
                            PlanarImage planarImage = (PlanarImage)cov.getRenderedImage();
                            ImageUtilities.disposePlanarImageChain((PlanarImage)planarImage);
                            cov = null;
                            waits = new TreeMap();
                            Pixel p = new Pixel(dx, dy);
                            if (this.calculTab[dy * this.dWidth + dx] == -1) {
                                if (dx > 0 && this.calculTab[dy * this.dWidth + (dx - 1)] >= 0) {
                                    bord = this.bords.get(p).get("left");
                                    for (int j = 0; j < roiHeight; ++j) {
                                        outDatas[j * roiWidth + 0] = bord[j];
                                        this.setPixelAndValue(waits, new Pixel(0, j), bord[j]);
                                    }
                                }
                                if (dy > 0 && this.calculTab[(dy - 1) * this.dWidth + dx] >= 0) {
                                    bord = this.bords.get(p).get("north");
                                    for (int i = 0; i < roiWidth; ++i) {
                                        outDatas[i] = bord[i];
                                        this.setPixelAndValue(waits, new Pixel(i, 0), bord[i]);
                                    }
                                }
                                if (dx < this.dWidth - 1 && this.calculTab[dy * this.dWidth + (dx + 1)] >= 0) {
                                    bord = this.bords.get(p).get("right");
                                    for (int j = 0; j < roiHeight; ++j) {
                                        outDatas[j * roiWidth + (roiWidth - 1)] = bord[j];
                                        this.setPixelAndValue(waits, new Pixel(roiWidth - 1, j), bord[j]);
                                    }
                                }
                                if (dy < this.dHeight - 1 && this.calculTab[(dy + 1) * this.dWidth + dx] >= 0) {
                                    bord = this.bords.get(p).get("south");
                                    for (int i = 0; i < roiWidth; ++i) {
                                        outDatas[(roiHeight - 1) * roiWidth + i] = bord[i];
                                        this.setPixelAndValue(waits, new Pixel(i, roiHeight - 1), bord[i]);
                                    }
                                }
                            } else {
                                if (dx > 0) {
                                    bord = this.bords.get(p).get("left");
                                    for (int j = 0; j < roiHeight; ++j) {
                                        if (!(bord[j] < outDatas[j * roiWidth + 0])) continue;
                                        outDatas[j * roiWidth + 0] = bord[j];
                                        this.setPixelAndValue(waits, new Pixel(0, j), bord[j]);
                                    }
                                }
                                if (dy > 0) {
                                    bord = this.bords.get(p).get("north");
                                    for (int i = 0; i < roiWidth; ++i) {
                                        if (!(bord[i] < outDatas[i])) continue;
                                        outDatas[i] = bord[i];
                                        this.setPixelAndValue(waits, new Pixel(i, 0), bord[i]);
                                    }
                                }
                                if (dx < this.dWidth - 1) {
                                    bord = this.bords.get(p).get("right");
                                    for (int j = 0; j < roiHeight; ++j) {
                                        if (!(bord[j] < outDatas[j * roiWidth + (roiWidth - 1)])) continue;
                                        outDatas[j * roiWidth + (roiWidth - 1)] = bord[j];
                                        this.setPixelAndValue(waits, new Pixel(roiWidth - 1, j), bord[j]);
                                    }
                                }
                                if (dy < this.dHeight - 1) {
                                    bord = this.bords.get(p).get("south");
                                    for (int i = 0; i < roiWidth; ++i) {
                                        if (!(bord[i] < outDatas[(roiHeight - 1) * roiWidth + i])) continue;
                                        outDatas[(roiHeight - 1) * roiWidth + i] = bord[i];
                                        this.setPixelAndValue(waits, new Pixel(i, roiHeight - 1), bord[i]);
                                    }
                                }
                            }
                            if (!(isFinish = this.bordUpdateFromData(dx, dy, roiWidth, roiHeight, roiPosMinX, roiPosMaxX, roiPosMinY, roiPosMaxY, outDatas = (float[])(ccd = new ArrayRCMDistanceAnalysis(outDatas, frictionDatas = CoverageManager.getData(this.frictionCoverage, x, y, roiWidth, roiHeight), roiWidth, roiHeight, this.cellSize, waits)).allRun()))) {
                                finish = false;
                            }
                            CoverageManager.writeGeotiff(new File(this.temp + "_" + dx + "-" + dy + ".tif"), outDatas, roiWidth, roiHeight, roiPosMinX, roiPosMaxX, roiPosMinY, roiPosMaxY);
                            this.majTab[dy * this.dWidth + dx] = 0;
                            this.calculTab[dy * this.dWidth + dx] = 1;
                        } else if (this.calculTab[dy * this.dWidth + dx] >= 0) {
                            this.calculTab[dy * this.dWidth + dx] = 0;
                        }
                        ++dx;
                    }
                    ++dy;
                }
            }
            ++pass;
        }
        this.compileToAsciiGrid();
    }

    private void setPixelAndValue(Map<Float, Set<Pixel>> waits, Pixel pixel, float value) {
        if (!waits.containsKey(Float.valueOf(value))) {
            waits.put(Float.valueOf(value), new HashSet());
        }
        waits.get(Float.valueOf(value)).add(pixel);
    }

    private boolean bordUpdateFromData(int dx, int dy, int roiWidth, int roiHeight, double roiPosMinX, double roiPosMaxX, double roiPosMinY, double roiPosMaxY, float[] outDatas) {
        int i;
        int j;
        float[] bord;
        boolean finish = true;
        Pixel p = new Pixel(dx, dy);
        if (dx > 0) {
            bord = this.bords.get(p).get("left");
            for (j = 0; j < roiHeight; ++j) {
                if (bord[j] == outDatas[j * roiWidth + 0]) continue;
                bord[j] = outDatas[j * roiWidth + 0];
                this.majTab[dy * this.dWidth + (dx - 1)] = 1;
                finish = false;
            }
        }
        if (dy > 0) {
            bord = this.bords.get(p).get("north");
            for (i = 0; i < roiWidth; ++i) {
                if (bord[i] == outDatas[i]) continue;
                bord[i] = outDatas[i];
                this.majTab[(dy - 1) * this.dWidth + dx] = 1;
                finish = false;
            }
        }
        if (dx < this.dWidth - 1) {
            bord = this.bords.get(p).get("right");
            for (j = 0; j < roiHeight; ++j) {
                if (bord[j] == outDatas[j * roiWidth + (roiWidth - 1)]) continue;
                bord[j] = outDatas[j * roiWidth + (roiWidth - 1)];
                this.majTab[dy * this.dWidth + (dx + 1)] = 1;
                finish = false;
            }
        }
        if (dy < this.dHeight - 1) {
            bord = this.bords.get(p).get("south");
            for (i = 0; i < roiWidth; ++i) {
                if (bord[i] == outDatas[(roiHeight - 1) * roiWidth + i]) continue;
                bord[i] = outDatas[(roiHeight - 1) * roiWidth + i];
                this.majTab[(dy + 1) * this.dWidth + dx] = 1;
                finish = false;
            }
        }
        return finish;
    }

    public void compileToAsciiGrid() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));
            writer.write("ncols " + this.width);
            writer.newLine();
            writer.write("nrows " + this.height);
            writer.newLine();
            writer.write("xllcorner " + this.imageMinX);
            writer.newLine();
            writer.write("yllcorner " + this.imageMinY);
            writer.newLine();
            writer.write("cellsize " + this.cellSize);
            writer.newLine();
            writer.write("NODATA_value " + Raster.getNoDataValue());
            writer.newLine();
            int dx = 0;
            int dy = 0;
            for (int y = 0; y < this.height; y += this.maxTile - 1) {
                int li;
                int ly;
                PlanarImage planarImage;
                int lx;
                int ly2;
                float[] localDatas;
                GridCoverage2D cov;
                int roiWidth;
                int x;
                float[] datas;
                dx = 0;
                int roiHeight = Math.min(this.maxTile, this.height - y);
                if (y == 0) {
                    datas = new float[this.width * roiHeight];
                    for (x = 0; x < this.width; x += this.maxTile - 1) {
                        roiWidth = Math.min(this.maxTile, this.width - x);
                        System.out.println("traitement de la tuile " + dx + " " + dy + " / " + this.dWidth + " " + this.dHeight + " " + x + " " + y + " " + roiWidth + " " + roiHeight);
                        if (x == 0) {
                            cov = CoverageManager.get(this.temp + "_" + dx + "-" + dy + ".tif");
                            localDatas = CoverageManager.getData(cov, 0, 0, roiWidth, roiHeight);
                            for (int li2 = 0; li2 < localDatas.length; ++li2) {
                                ly2 = li2 / roiWidth;
                                lx = li2 % roiWidth;
                                datas[ly2 * this.width + lx] = localDatas[li2];
                            }
                            cov.dispose(true);
                            planarImage = (PlanarImage)cov.getRenderedImage();
                            ImageUtilities.disposePlanarImageChain((PlanarImage)planarImage);
                            cov = null;
                        } else {
                            cov = CoverageManager.get(this.temp + "_" + dx + "-" + dy + ".tif");
                            localDatas = CoverageManager.getData(cov, 1, 0, roiWidth - 1, roiHeight);
                            for (int li3 = 0; li3 < localDatas.length; ++li3) {
                                ly2 = li3 / (roiWidth - 1);
                                lx = dx * this.maxTile - dx + 1 + li3 % (roiWidth - 1);
                                datas[ly2 * this.width + lx] = localDatas[li3];
                            }
                            cov.dispose(true);
                            planarImage = (PlanarImage)cov.getRenderedImage();
                            ImageUtilities.disposePlanarImageChain((PlanarImage)planarImage);
                            cov = null;
                        }
                        new File(this.temp + "_" + dx + "-" + dy + ".tif").delete();
                        ++dx;
                    }
                    for (ly = 0; ly < roiHeight; ++ly) {
                        for (li = 0; li < this.width; ++li) {
                            writer.write(datas[ly * this.width + li] + " ");
                        }
                        writer.newLine();
                    }
                } else {
                    datas = new float[this.width * (roiHeight - 1)];
                    for (x = 0; x < this.width; x += this.maxTile - 1) {
                        roiWidth = Math.min(this.maxTile, this.width - x);
                        System.out.println("traitement de la tuile " + dx + " " + dy + " / " + this.dWidth + " " + this.dHeight + " " + x + " " + y + " " + roiWidth + " " + roiHeight);
                        if (x == 0) {
                            cov = CoverageManager.get(this.temp + "_" + dx + "-" + dy + ".tif");
                            localDatas = CoverageManager.getData(cov, 0, 1, roiWidth, roiHeight - 1);
                            for (int li4 = 0; li4 < localDatas.length; ++li4) {
                                ly2 = li4 / roiWidth;
                                lx = li4 % roiWidth;
                                datas[ly2 * this.width + lx] = localDatas[li4];
                            }
                            cov.dispose(true);
                            planarImage = (PlanarImage)cov.getRenderedImage();
                            ImageUtilities.disposePlanarImageChain((PlanarImage)planarImage);
                            cov = null;
                        } else {
                            cov = CoverageManager.get(this.temp + "_" + dx + "-" + dy + ".tif");
                            localDatas = CoverageManager.getData(cov, 1, 1, roiWidth - 1, roiHeight - 1);
                            for (int li5 = 0; li5 < localDatas.length; ++li5) {
                                ly2 = li5 / (roiWidth - 1);
                                lx = dx * this.maxTile - dx + 1 + li5 % (roiWidth - 1);
                                datas[ly2 * this.width + lx] = localDatas[li5];
                            }
                            cov.dispose(true);
                            planarImage = (PlanarImage)cov.getRenderedImage();
                            ImageUtilities.disposePlanarImageChain((PlanarImage)planarImage);
                            cov = null;
                        }
                        new File(this.temp + "_" + dx + "-" + dy + ".tif").delete();
                        ++dx;
                    }
                    for (ly = 0; ly < roiHeight - 1; ++ly) {
                        for (li = 0; li < this.width; ++li) {
                            writer.write(datas[ly * this.width + li] + " ");
                        }
                        writer.newLine();
                    }
                }
                ++dy;
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void doClose() {
        this.bords.clear();
        this.bords = null;
    }
}

