/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RCMDistanceCalculation
extends MatrixCalculation {
    private Collection<Integer> values;
    private boolean map;
    private Friction frictionMap;
    private double[] mat;
    private double[] frictionMat;
    private double threshold;
    private int width;
    private int height;
    private int total;

    public RCMDistanceCalculation(Matrix m, Friction f, Collection<Integer> values) {
        this(m, f, values, (double)Raster.getNoDataValue());
    }

    public RCMDistanceCalculation(Matrix m, Friction f, Collection<Integer> values, double threshold) {
        super(m);
        this.width = m.width();
        this.height = m.height();
        this.mat = new double[this.width * this.height];
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                this.mat[i + j * this.width] = m.get(i, j);
            }
        }
        this.frictionMap = f;
        this.map = true;
        this.values = values;
        this.threshold = threshold == (double)Raster.getNoDataValue() ? 2.147483647E9 : threshold;
    }

    public RCMDistanceCalculation(Matrix m, Matrix f, Collection<Integer> values) {
        this(m, f, values, (double)Raster.getNoDataValue());
    }

    public RCMDistanceCalculation(Matrix m, Matrix f, Collection<Integer> values, double threshold) {
        super(m);
        this.width = m.width();
        this.height = m.height();
        this.mat = new double[this.width * this.height];
        this.frictionMat = new double[this.width * this.height];
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                this.mat[i + j * this.width] = m.get(i, j);
                this.frictionMat[i + j * this.width] = f.get(i, j);
            }
        }
        this.map = false;
        this.values = values;
        this.threshold = threshold == (double)Raster.getNoDataValue() ? 2.147483647E9 : threshold;
    }

    @Override
    public void doInit() {
    }

    @Override
    public void doRun() {
        int x;
        int y;
        int v;
        double[] dist = new double[this.width * this.height];
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                dist[i + j * this.width] = this.threshold;
            }
        }
        this.total = this.width * this.height * 4;
        TreeMap<Double, Set<Pixel>> waits = new TreeMap<Double, Set<Pixel>>();
        for (int y2 = 0; y2 < this.height; ++y2) {
            for (int x2 = 0; x2 < this.width; ++x2) {
                v = new Double(this.mat[x2 + y2 * this.width]).intValue();
                if (this.values.contains(v)) {
                    dist[x2 + y2 * this.width] = 0.0;
                    int v0 = new Double(this.matrix().get(x2 - 1, y2)).intValue();
                    if (v0 == Raster.getNoDataValue() || this.values.contains(v0)) {
                        int v1 = new Double(this.matrix().get(x2 - 1, y2 - 1)).intValue();
                        if (v1 == Raster.getNoDataValue() || this.values.contains(v1)) {
                            int v2 = new Double(this.matrix().get(x2 - 1, y2 + 1)).intValue();
                            if (v2 == Raster.getNoDataValue() || this.values.contains(v2)) {
                                int v3 = new Double(this.matrix().get(x2, y2 + 1)).intValue();
                                if (v3 == Raster.getNoDataValue() || this.values.contains(v3)) {
                                    int v4 = new Double(this.matrix().get(x2, y2 - 1)).intValue();
                                    if (v4 == Raster.getNoDataValue() || this.values.contains(v4)) {
                                        int v5 = new Double(this.matrix().get(x2 + 1, y2 - 1)).intValue();
                                        if (v5 == Raster.getNoDataValue() || this.values.contains(v5)) {
                                            int v6 = new Double(this.matrix().get(x2 + 1, y2)).intValue();
                                            if (v6 == Raster.getNoDataValue() || this.values.contains(v6)) {
                                                int v7 = new Double(this.matrix().get(x2 + 1, y2 + 1)).intValue();
                                                if (v7 != Raster.getNoDataValue() && !this.values.contains(v7)) {
                                                    this.setPixelAndValue(waits, new Pixel(x2, y2), 0.0);
                                                }
                                            } else {
                                                this.setPixelAndValue(waits, new Pixel(x2, y2), 0.0);
                                            }
                                        } else {
                                            this.setPixelAndValue(waits, new Pixel(x2, y2), 0.0);
                                        }
                                    } else {
                                        this.setPixelAndValue(waits, new Pixel(x2, y2), 0.0);
                                    }
                                } else {
                                    this.setPixelAndValue(waits, new Pixel(x2, y2), 0.0);
                                }
                            } else {
                                this.setPixelAndValue(waits, new Pixel(x2, y2), 0.0);
                            }
                        } else {
                            this.setPixelAndValue(waits, new Pixel(x2, y2), 0.0);
                        }
                    } else {
                        this.setPixelAndValue(waits, new Pixel(x2, y2), 0.0);
                    }
                }
                this.updateProgression(this.total);
            }
        }
        int treat = 0;
        while (waits.size() > 0) {
            treat = this.diffusionPaquet(treat, dist, waits);
        }
        if (this.frictionMat != null) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    v = new Double(this.frictionMat[x + y * this.width]).intValue();
                    if (v == Raster.getNoDataValue()) {
                        dist[x + y * this.width] = Raster.getNoDataValue();
                    }
                    this.updateProgression(this.total);
                }
            }
        } else {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    v = new Double(this.mat[x + y * this.width]).intValue();
                    if (v == Raster.getNoDataValue()) {
                        dist[x + y * this.width] = Raster.getNoDataValue();
                    }
                    this.updateProgression(this.total);
                }
            }
        }
        Matrix mdist = MatrixFactory.get(this.matrix().getType()).create(this.matrix().width(), this.matrix().height(), this.matrix().cellsize(), this.matrix().minX(), this.matrix().maxX(), this.matrix().minY(), this.matrix().maxY(), this.matrix().noDataValue());
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                mdist.put(i, j, dist[i + j * this.width]);
                this.updateProgression(this.total);
            }
        }
        this.setResult(mdist);
    }

    private void setPixelAndValue(Map<Double, Set<Pixel>> waits, Pixel pixel, Double value) {
        if (!waits.containsKey(value)) {
            waits.put(value, new HashSet());
        }
        waits.get(value).add(pixel);
    }

    private int diffusionPaquet(int treat, double[] dist, Map<Double, Set<Pixel>> waits) {
        Iterator<Map.Entry<Double, Set<Pixel>>> iteEntry = waits.entrySet().iterator();
        Map.Entry<Double, Set<Pixel>> entry = iteEntry.next();
        iteEntry.remove();
        if (entry.getValue().size() != 0) {
            double dd = entry.getKey();
            Iterator<Pixel> itePixel = entry.getValue().iterator();
            while (itePixel.hasNext()) {
                Pixel p = itePixel.next();
                itePixel.remove();
                treat = this.diffusion(treat, dist, waits, p, dd);
            }
        }
        return treat;
    }

    private int diffusion(int treat, double[] dist, Map<Double, Set<Pixel>> waits, Pixel p, double dd) {
        double fd;
        double vd;
        if (this.threshold > dd && (vd = this.mat[p.x() + p.y() * this.width]) != (double)Raster.getNoDataValue() && (fd = this.friction(vd, p.x(), p.y())) != (double)Raster.getNoDataValue()) {
            double vdn;
            double d;
            double fc;
            double v;
            Pixel np;
            Iterator<Pixel> ite = p.getCardinalMargins();
            while (ite.hasNext()) {
                np = ite.next();
                if (np.x() < 0 || np.x() >= this.width || np.y() < 0 || np.y() >= this.height || (v = this.mat[np.x() + np.y() * this.width]) == (double)Raster.getNoDataValue() || (fc = this.friction(v, np.x(), np.y())) == (double)Raster.getNoDataValue() || !((d = dd + this.matrix().cellsize() / 2.0 * fd + this.matrix().cellsize() / 2.0 * fc) < (vdn = dist[np.x() + np.y() * this.width]))) continue;
                dist[np.x() + np.y() * this.width] = d;
                if (vdn != this.threshold) {
                    waits.get(vdn).remove(np);
                }
                this.setPixelAndValue(waits, np, d);
            }
            ite = p.getDiagonalMargins();
            while (ite.hasNext()) {
                np = ite.next();
                if (np.x() < 0 || np.x() >= this.width || np.y() < 0 || np.y() >= this.height || (v = this.mat[np.x() + np.y() * this.width]) == (double)Raster.getNoDataValue() || (fc = this.friction(v, np.x(), np.y())) == (double)Raster.getNoDataValue() || !((d = dd + this.matrix().cellsize() * Math.sqrt(2.0) / 2.0 * fd + this.matrix().cellsize() * Math.sqrt(2.0) / 2.0 * fc) < (vdn = dist[np.x() + np.y() * this.width]))) continue;
                dist[np.x() + np.y() * this.width] = d;
                if (vdn != this.threshold) {
                    waits.get(vdn).remove(np);
                }
                this.setPixelAndValue(waits, np, d);
            }
        }
        this.updateProgression(this.total);
        return treat + 1;
    }

    private double friction(double v, int x, int y) {
        if (this.map) {
            return this.frictionMap.get(v);
        }
        return this.frictionMat[x + y * this.width];
    }

    @Override
    public void doClose() {
    }
}

