/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RCMDistanceCalculationTest
extends MatrixCalculation {
    private Collection<Integer> values;
    private boolean map;
    private Friction frictionMap;
    private Matrix frictionMat;
    private double threshold;

    public RCMDistanceCalculationTest(Matrix m, Friction f, Collection<Integer> values) {
        this(m, f, values, (double)Raster.getNoDataValue());
    }

    public RCMDistanceCalculationTest(Matrix m, Friction f, Collection<Integer> values, double threshold) {
        super(m);
        this.frictionMap = f;
        this.map = true;
        this.values = values;
        this.threshold = threshold;
    }

    public RCMDistanceCalculationTest(Matrix m, Matrix f, Collection<Integer> values) {
        this(m, f, values, (double)Raster.getNoDataValue());
    }

    public RCMDistanceCalculationTest(Matrix m, Matrix f, Collection<Integer> values, double threshold) {
        super(m);
        this.frictionMat = f;
        this.map = false;
        this.values = values;
        this.threshold = threshold;
    }

    @Override
    public void doInit() {
    }

    @Override
    public void doRun() {
        int v;
        System.out.println("cr\ufffdation de la matrice");
        Matrix dist = MatrixFactory.get(this.matrix().getType()).create(this.matrix().width(), this.matrix().height(), this.matrix().cellsize(), this.matrix().minX(), this.matrix().maxX(), this.matrix().minY(), this.matrix().maxY(), this.matrix().noDataValue());
        System.out.println("initialisation de la matrice");
        if (this.threshold != (double)Raster.getNoDataValue()) {
            dist.init(this.threshold);
        } else {
            dist.init(2.147483647E9);
        }
        int width = this.matrix().width();
        int height = this.matrix().height();
        int total = width * height * 2;
        HashMap<Pixel, Double> waits = new HashMap<Pixel, Double>();
        PixelWithValueComparator pComparator = new PixelWithValueComparator(waits);
        TreeSet<Pixel> sortedWaits = new TreeSet<Pixel>(pComparator);
        System.out.println("r\ufffdcup\ufffdration des pixels sources");
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                v = new Double(this.matrix().get(x, y)).intValue();
                if (this.values.contains(v)) {
                    dist.put(x, y, 0.0);
                    int v0 = new Double(this.matrix().get(x - 1, y)).intValue();
                    if (v0 == Raster.getNoDataValue() || this.values.contains(v0)) {
                        int v1 = new Double(this.matrix().get(x - 1, y - 1)).intValue();
                        if (v1 == Raster.getNoDataValue() || this.values.contains(v1)) {
                            int v2 = new Double(this.matrix().get(x - 1, y + 1)).intValue();
                            if (v2 == Raster.getNoDataValue() || this.values.contains(v2)) {
                                int v3 = new Double(this.matrix().get(x, y + 1)).intValue();
                                if (v3 == Raster.getNoDataValue() || this.values.contains(v3)) {
                                    int v4 = new Double(this.matrix().get(x, y - 1)).intValue();
                                    if (v4 == Raster.getNoDataValue() || this.values.contains(v4)) {
                                        int v5 = new Double(this.matrix().get(x + 1, y - 1)).intValue();
                                        if (v5 == Raster.getNoDataValue() || this.values.contains(v5)) {
                                            int v6 = new Double(this.matrix().get(x + 1, y)).intValue();
                                            if (v6 == Raster.getNoDataValue() || this.values.contains(v6)) {
                                                int v7 = new Double(this.matrix().get(x + 1, y + 1)).intValue();
                                                if (v7 != Raster.getNoDataValue() && !this.values.contains(v7)) {
                                                    waits.put(new Pixel(x, y), 0.0);
                                                }
                                            } else {
                                                waits.put(new Pixel(x, y), 0.0);
                                            }
                                        } else {
                                            waits.put(new Pixel(x, y), 0.0);
                                        }
                                    } else {
                                        waits.put(new Pixel(x, y), 0.0);
                                    }
                                } else {
                                    waits.put(new Pixel(x, y), 0.0);
                                }
                            } else {
                                waits.put(new Pixel(x, y), 0.0);
                            }
                        } else {
                            waits.put(new Pixel(x, y), 0.0);
                        }
                    } else {
                        waits.put(new Pixel(x, y), 0.0);
                    }
                }
                this.updateProgression(total);
            }
        }
        sortedWaits.addAll(waits.keySet());
        System.out.println("d\ufffdbut " + waits.size() + " " + sortedWaits.size());
        System.out.println("s\ufffdlection des pixels sources");
        System.out.println("diffusion");
        int treat = 0;
        while (waits.size() > 0) {
            if (waits.size() % 10000 == 0) {
                System.out.println(treat + " " + waits.size() + " " + sortedWaits.size());
            }
            treat = this.diffusion(treat, this.matrix(), dist, waits, sortedWaits);
        }
        System.out.println("fin diffusion");
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                v = new Double(this.matrix().get(x, y)).intValue();
                if (v == Raster.getNoDataValue()) {
                    dist.put(x, y, Raster.getNoDataValue());
                }
                this.updateProgression(total);
            }
        }
        this.setResult(dist);
    }

    private int diffusion(int treat, Matrix m, Matrix dist, Map<Pixel, Double> waits, Set<Pixel> sortedWaits) {
        Pixel p = sortedWaits.iterator().next();
        double dd = waits.get(p);
        sortedWaits.remove(p);
        waits.remove(p);
        if (this.threshold == (double)Raster.getNoDataValue() || this.threshold > dd) {
            double vdn;
            double d;
            double fc;
            double v;
            Pixel np;
            double vd = m.get(p);
            double fd = this.friction(vd, p.x(), p.y());
            Iterator<Pixel> ite = p.getCardinalMargins();
            while (ite.hasNext()) {
                np = ite.next();
                v = m.get(np);
                if (v == (double)Raster.getNoDataValue()) continue;
                fc = this.friction(v, np.x(), np.y());
                d = dd + m.cellsize() / 2.0 * fd + m.cellsize() / 2.0 * fc;
                if (!(d < (vdn = dist.get(np)))) continue;
                dist.put(np, d);
                if (waits.keySet().contains(np)) {
                    if (!sortedWaits.remove(np)) {
                        System.out.println();
                        for (Pixel px : sortedWaits) {
                            System.out.println(np + " " + px + " " + waits.get(px));
                        }
                        System.out.println();
                    }
                    waits.replace(np, vdn, d);
                    sortedWaits.add(np);
                    continue;
                }
                waits.put(np, d);
                sortedWaits.add(np);
            }
            ite = p.getDiagonalMargins();
            while (ite.hasNext()) {
                np = ite.next();
                v = m.get(np);
                if (v == (double)Raster.getNoDataValue()) continue;
                fc = this.friction(v, np.x(), np.y());
                d = dd + m.cellsize() * Math.sqrt(2.0) / 2.0 * fd + m.cellsize() * Math.sqrt(2.0) / 2.0 * fc;
                if (!(d < (vdn = dist.get(np)))) continue;
                dist.put(np, d);
                if (waits.keySet().contains(np)) {
                    System.out.println(sortedWaits.remove(np));
                    waits.replace(np, vdn, d);
                    sortedWaits.add(np);
                    continue;
                }
                waits.put(np, d);
                sortedWaits.add(np);
            }
        }
        return treat + 1;
    }

    private double friction(double v, int x, int y) {
        if (this.map) {
            return this.frictionMap.get(v);
        }
        return this.frictionMat.get(x, y);
    }

    @Override
    public void doClose() {
    }

    private class PixelWithValueComparator
    implements Comparator<Pixel> {
        private Map<Pixel, Double> map;

        public PixelWithValueComparator(Map<Pixel, Double> map) {
            this.map = map;
        }

        @Override
        public int compare(Pixel p1, Pixel p2) {
            if (p1.equals(p2)) {
                return 0;
            }
            int value = this.map.get(p1).compareTo(this.map.get(p2));
            if (value < 1) {
                return -1;
            }
            return 1;
        }
    }
}

