/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.ArrayRCMDistanceAnalysis;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RCMDistanceTabAnalysis
extends Analysis {
    private float[] inSource;
    private float[] inFriction;
    private float[] output;
    private float[] inEdges;
    private int width;
    private int height;
    private float cellSize;
    private int[] codes;
    private float threshold;

    public RCMDistanceTabAnalysis(float[] output, float[] inSource, float[] inFriction, int width, int height, float cellSize, int[] codes) {
        this(output, inSource, inFriction, null, width, height, cellSize, codes, Raster.getNoDataValue());
    }

    public RCMDistanceTabAnalysis(float[] output, float[] inSource, float[] inFriction, float[] inEdges, int width, int height, float cellSize, int[] codes) {
        this(output, inSource, inFriction, inEdges, width, height, cellSize, codes, Raster.getNoDataValue());
    }

    public RCMDistanceTabAnalysis(float[] output, float[] inSource, float[] inFriction, float[] inEdges, int width, int height, float cellSize, int[] codes, float threshold) {
        this.output = output;
        this.inSource = inSource;
        this.inFriction = inFriction;
        this.inEdges = inEdges;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.codes = codes;
        this.threshold = threshold;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doRun() {
        int y;
        boolean hasValue = false;
        for (int y2 = 0; y2 < this.height; ++y2) {
            for (int x = 0; x < this.width; ++x) {
                float v = this.inSource[y2 * this.width + x];
                boolean ok = false;
                if (v != (float)Raster.getNoDataValue()) {
                    for (int c : this.codes) {
                        if ((float)c != v) continue;
                        ok = true;
                        hasValue = true;
                        break;
                    }
                    if (ok) {
                        this.output[y2 * this.width + x] = 0.0f;
                        continue;
                    }
                    this.output[y2 * this.width + x] = -2.0f;
                    continue;
                }
                this.output[y2 * this.width + x] = Raster.getNoDataValue();
            }
        }
        TreeMap<Float, Set<Pixel>> waits = new TreeMap<Float, Set<Pixel>>();
        boolean maj = false;
        for (y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.output[y * this.width + x] != 0.0f) continue;
                maj = true;
                if (!(x != 0 && this.output[x - 1 + y * this.width] != 0.0f || x != 0 && y != 0 && this.output[x - 1 + (y - 1) * this.width] != 0.0f || y != 0 && this.output[x + (y - 1) * this.width] != 0.0f || x != this.width - 1 && y != 0 && this.output[x + 1 + (y - 1) * this.width] != 0.0f || x != this.width - 1 && this.output[x + 1 + y * this.width] != 0.0f || x != this.width - 1 && y != this.height - 1 && this.output[x + 1 + (y + 1) * this.width] != 0.0f || y != this.height - 1 && this.output[x + (y + 1) * this.width] != 0.0f || x != 0 && y != this.height - 1 && this.output[x - 1 + (y + 1) * this.width] != 0.0f)) {
                    maj = false;
                }
                if (!maj) continue;
                this.setPixelAndValue(waits, new Pixel(x, y), 0.0f);
            }
        }
        if (this.inEdges != null) {
            for (int x = 0; x < this.width; ++x) {
                this.output[x] = this.inEdges[x];
                this.setPixelAndValue(waits, new Pixel(x, 0), this.inEdges[x]);
                this.output[(this.height - 1) * this.width + x] = this.inEdges[(this.height - 1) * this.width + x];
                this.setPixelAndValue(waits, new Pixel(x, this.height - 1), this.inEdges[(this.height - 1) * this.width + x]);
            }
            for (y = 1; y < this.height - 1; ++y) {
                this.output[y * this.width] = this.inEdges[y * this.width];
                this.setPixelAndValue(waits, new Pixel(0, y), this.inEdges[y * this.width]);
                this.output[y * this.width + (this.width - 1)] = this.inEdges[y * this.width + (this.width - 1)];
                this.setPixelAndValue(waits, new Pixel(this.width - 1, y), this.inEdges[y * this.width + (this.width - 1)]);
            }
        }
        if (hasValue) {
            ArrayRCMDistanceAnalysis rcm = new ArrayRCMDistanceAnalysis(this.output, this.inFriction, this.width, this.height, this.cellSize, waits);
            this.setResult(rcm.allRun());
        }
    }

    private void setPixelAndValue(Map<Float, Set<Pixel>> waits, Pixel pixel, float value) {
        if (!waits.containsKey(Float.valueOf(value))) {
            waits.put(Float.valueOf(value), new HashSet());
        }
        waits.get(Float.valueOf(value)).add(pixel);
    }

    @Override
    protected void doClose() {
    }
}

