/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.cluster;

import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixAnalysis;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

public abstract class ClusteringAnalysis
extends MatrixAnalysis {
    private int value;
    private Set<Integer> interest;
    private int nbPixel = 0;
    private int size;

    public ClusteringAnalysis(Matrix m, Set<Integer> interest) {
        super(m);
        this.interest = interest;
        this.size = m.height() * m.width();
    }

    @Override
    public void doInit() {
        this.value = Raster.getNoDataValue();
    }

    @Override
    public void doRun() {
        RasterComposite r = new RasterComposite();
        TreeSet<Pixel> ever = new TreeSet<Pixel>();
        int oldy = -1;
        int index = 0;
        int total = this.matrix().width() * this.matrix().height();
        for (Pixel p : this.matrix()) {
            if (p.y() > oldy) {
                Iterator ite = ever.iterator();
                while (ite.hasNext() && ((Pixel)ite.next()).y() == oldy) {
                    ite.remove();
                }
                oldy = p.y();
            }
            if (!ever.contains(p)) {
                ever.add(p);
                double v = this.matrix().get(p);
                if (v != (double)Raster.getNoDataValue()) {
                    if (this.interest == null || this.interest.contains((int)v)) {
                        this.value = (int)v;
                        PixelComposite pc = this.diffuseFromPixel(this.matrix(), p, ever, new PixelComposite(p, ++index, this.value));
                        r.addSimplePixelComposite(pc);
                    } else {
                        this.value = (int)v;
                    }
                }
            }
            this.updateProgression(total);
        }
        this.setResult(r.smooth());
    }

    private PixelComposite diffuseFromPixel(Matrix m, Pixel p, Set<Pixel> ever, PixelComposite pc) {
        LinkedList<Pixel> next = new LinkedList<Pixel>();
        next.add(p);
        while (!next.isEmpty()) {
            Pixel np = (Pixel)next.poll();
            this.treatPixel(m, np, ever, next);
            pc.addSimplePixel(np);
        }
        pc.setUserData(this.value);
        this.value = Raster.getNoDataValue();
        return pc;
    }

    private boolean treatPixel(Matrix m, Pixel p, Set<Pixel> ever, LinkedList<Pixel> next) {
        Iterator<Pixel> ite = this.getMargins(p);
        while (ite.hasNext()) {
            Pixel np = ite.next();
            if (ever.contains(np) || !m.contains(np) || (int)m.get(np) != this.value) continue;
            next.addLast(np);
            ever.add(np);
        }
        ite = null;
        return true;
    }

    @Override
    public Raster getResult() {
        return (Raster)super.getResult();
    }

    @Override
    public void doClose() {
    }

    public abstract Iterator<Pixel> getMargins(Pixel var1);
}

