/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.cluster;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ClusteringCsvOutput
implements AnalysisObserver {
    private String csv;

    public ClusteringCsvOutput(String csv) {
        this.csv = csv;
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
        switch (state) {
            case DONE: {
                TreeMap map = new TreeMap();
                for (Raster raster : ((RasterComposite)ma.getResult()).getRasters()) {
                    int n = ((PixelComposite)raster).getValue();
                    if (!map.containsKey(n)) {
                        map.put(n, new HashSet());
                    }
                    ((Set)map.get(n)).add((PixelComposite)raster);
                }
                CsvWriter cw = new CsvWriter(this.csv);
                cw.setDelimiter(';');
                try {
                    cw.write("id");
                    cw.write("count");
                    cw.write("area");
                    cw.endRecord();
                    for (Map.Entry entry : map.entrySet()) {
                        cw.write(entry.getKey() + "");
                        int size = 0;
                        for (PixelComposite pc : (Set)entry.getValue()) {
                            size += pc.size();
                        }
                        cw.write(size + "");
                        cw.write((double)size * Math.pow(Raster.getCellSize(), 2.0) + "");
                        cw.endRecord();
                    }
                    cw.close();
                    break;
                }
                catch (CsvWriter.FinalizedException | IOException throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    @Override
    public void updateProgression(Analysis a, int total) {
    }
}

