/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.cluster;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Count;
import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixAnalysis;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ClusteringOutput
extends MatrixAnalysis {
    private List<Integer> values;
    private List<Double> minimumAreas;
    private double minimumTotal;
    private String csv;
    private Map<Integer, Map<Integer, Count>> patchs;
    private double totalSurface = 0.0;
    private int nbPatch = 0;

    public ClusteringOutput(List<Integer> values, List<Double> minimumAreas, double minimumTotal, String csv, Matrix ... matrix) {
        super(matrix);
        this.values = values;
        this.minimumAreas = minimumAreas;
        this.minimumTotal = minimumTotal;
        this.csv = csv;
    }

    public double getTotalSurface() {
        return this.totalSurface;
    }

    public int getNbPatch() {
        return this.nbPatch;
    }

    @Override
    protected void doInit() {
        this.patchs = new TreeMap<Integer, Map<Integer, Count>>();
        for (int vC : this.matrix(0).values()) {
            if (vC == 0 || vC == Raster.getNoDataValue()) continue;
            this.patchs.put(vC, new TreeMap());
            for (int vM : this.values) {
                this.patchs.get(vC).put(vM, new Count());
            }
        }
    }

    @Override
    protected void doRun() {
        int total = this.matrix().width() * this.matrix().height() * 3;
        for (int j = 0; j < this.matrix().height(); ++j) {
            for (int i = 0; i < this.matrix().width(); ++i) {
                double vC = this.matrix(0).get(i, j);
                if (vC > 0.0) {
                    this.patchs.get((int)vC).get((int)this.matrix(1).get(i, j)).add();
                }
                this.updateProgression(total);
            }
        }
        HashSet<Integer> toDelete = new HashSet<Integer>();
        for (Map.Entry<Integer, Map<Integer, Count>> e : this.patchs.entrySet()) {
            int patchNumber = e.getKey();
            double totalSurface = 0.0;
            for (Map.Entry<Integer, Count> e2 : this.patchs.get(e.getKey()).entrySet()) {
                double surface = (double)e2.getValue().get() * Math.pow(Raster.getCellSize(), 2.0);
                totalSurface += surface;
            }
            if (totalSurface != 0.0 && !(totalSurface < this.minimumTotal * 10000.0)) continue;
            toDelete.add(patchNumber);
        }
        if (toDelete.size() > 0) {
            Iterator<Map.Entry<Integer, Map<Integer, Count>>> i = toDelete.iterator();
            while (i.hasNext()) {
                int pn = (Integer)((Object)i.next());
                this.patchs.remove(pn);
            }
            for (int j = 0; j < this.matrix().height(); ++j) {
                for (int i2 = 0; i2 < this.matrix().width(); ++i2) {
                    double vC = this.matrix(0).get(i2, j);
                    if (!toDelete.contains((int)vC)) continue;
                    this.matrix(0).put(i2, j, 0.0);
                }
            }
        }
        this.setResult(this.matrix(0));
    }

    @Override
    protected void doClose() {
        try {
            CsvWriter cw = new CsvWriter(this.csv);
            cw.setDelimiter(';');
            cw.write("id");
            cw.write("nb_pixels_patch");
            cw.write("surface_patch");
            for (int vM : this.values) {
                if (vM == 0 || vM == Raster.getNoDataValue()) continue;
                cw.write("nb_pixels_patch_" + vM);
                cw.write("surface_patch_" + vM);
                cw.write("rate_patch_" + vM);
            }
            cw.endRecord();
            for (int vC : this.patchs.keySet()) {
                if (vC == 0 || vC == Raster.getNoDataValue()) continue;
                cw.write(vC + "");
                int nbpp = 0;
                for (int vM : this.values) {
                    if (vM == 0 || vM == Raster.getNoDataValue()) continue;
                    nbpp += this.patchs.get(vC).get(vM).get();
                }
                cw.write(nbpp + "");
                cw.write((double)nbpp * Math.pow(Raster.getCellSize(), 2.0) / 10000.0 + "");
                ++this.nbPatch;
                this.totalSurface += (double)nbpp * Math.pow(Raster.getCellSize(), 2.0) / 10000.0;
                int nbpsp = 0;
                for (int vM : this.values) {
                    if (vM == 0 || vM == Raster.getNoDataValue()) continue;
                    nbpsp = this.patchs.get(vC).get(vM).get();
                    cw.write(nbpsp + "");
                    cw.write((double)nbpsp * Math.pow(Raster.getCellSize(), 2.0) / 10000.0 + "");
                    cw.write((double)nbpsp * 100.0 / (double)nbpp + "");
                }
                cw.endRecord();
            }
            cw.close();
        }
        catch (CsvWriter.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }
}

