/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.cluster;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusterOverlay;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringQueenAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.MatrixOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.pixel.Pixel2PixelMatrixCalculation;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.qualitative.value.CountValueMetric;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysisBuilder;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.CircleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShapeType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.distance.DistanceFunction;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.CenteredWindow;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import java.util.HashSet;
import java.util.Set;

public class ClusteringSlidingAnalysis
extends MatrixAnalysis
implements AnalysisObserver {
    private double distance;
    private int size;
    private Set<Integer> interest;
    private String path;
    private String name;
    private int gTotal;
    private Friction frictionMap;
    private Matrix frictionMat;

    public ClusteringSlidingAnalysis(Matrix m, double distance, Set<Integer> interest, String path, String name, Friction frictionMap) {
        this(m, distance, interest, path, name);
        this.frictionMap = frictionMap;
    }

    public ClusteringSlidingAnalysis(Matrix m, double distance, Set<Integer> interest, String path, String name, Matrix frictionMat) {
        this(m, distance, interest, path, name);
        this.frictionMat = frictionMat;
    }

    public ClusteringSlidingAnalysis(Matrix m, double distance, Set<Integer> interest, String path, String name) {
        super(m);
        this.distance = distance;
        this.getSize();
        this.interest = interest;
        this.path = path + "/";
        this.name = name;
        this.gTotal = 4 * this.matrix().size();
    }

    private void getSize() {
        this.size = 3;
        while ((double)this.size * Raster.getCellSize() < this.distance) {
            this.size += 2;
        }
    }

    @Override
    protected void doRun() {
        try {
            Matrix[] mNV = this.sliding(this.matrix());
            Matrix mClassif = this.classification(mNV);
            Matrix mCluster = this.cluster(mClassif);
            this.overlay(this.matrix(), mCluster);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private Matrix[] sliding(Matrix matrix) {
        try {
            WindowMatrixProcessType pt = new WindowMatrixProcessType(matrix);
            for (int v : this.interest) {
                pt.addMetric(new CountValueMetric(v));
            }
            CenteredWindow w = new CenteredWindow(new CircleWindow(this.size));
            w = this.frictionMap != null ? new CenteredWindow(WindowShapeType.FUNCTIONAL.create(matrix, this.distance / 2.0, this.frictionMap, pt, null)) : (this.frictionMat != null ? new CenteredWindow(WindowShapeType.FUNCTIONAL.create(matrix, this.distance / 2.0, this.frictionMat, pt, null)) : new CenteredWindow(WindowShapeType.CIRCLE.create(this.size, (DistanceFunction)null)));
            WindowMatrixAnalysisBuilder builder = new WindowMatrixAnalysisBuilder(WindowAnalysisType.SLIDING);
            builder.addMatrix(matrix);
            builder.setWindow(w);
            builder.setProcessType(pt);
            HashSet<MatrixOutput> mos = new HashSet<MatrixOutput>();
            for (int v : this.interest) {
                MatrixOutput mo = new MatrixOutput("NV_" + v, matrix);
                builder.addObserver(mo);
                mos.add(mo);
            }
            Object wa = builder.build();
            ((Analysis)wa).addObserver(this);
            ((Analysis)wa).allRun();
            Matrix[] m = new Matrix[mos.size()];
            int i = 0;
            for (MatrixOutput mo : mos) {
                m[i++] = mo.getMatrix();
            }
            return m;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Matrix classification(Matrix[] mNV) {
        try {
            Pixel2PixelMatrixCalculation classif = new Pixel2PixelMatrixCalculation(mNV){

                @Override
                protected double treatPixel(Pixel p) {
                    for (Matrix mat : this.wholeMatrix()) {
                        double v = mat.get(p);
                        if (v > 0.0) {
                            return 1.0;
                        }
                        if (v != (double)Raster.getNoDataValue()) continue;
                        return Raster.getNoDataValue();
                    }
                    return 0.0;
                }
            };
            classif.addObserver(this);
            Matrix m = classif.allRun();
            return m;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Matrix cluster(Matrix mClassif) {
        try {
            HashSet<Integer> vcluster = new HashSet<Integer>();
            vcluster.add(1);
            ClusteringQueenAnalysis cqa = new ClusteringQueenAnalysis(mClassif, vcluster);
            cqa.addObserver(this);
            Matrix mCluster = RasterManager.exportMatrix((Raster)cqa.allRun(), mClassif);
            MatrixManager.exportAsciiGrid(mCluster, this.path + "/cluster_queen.asc");
            return mCluster;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void overlay(Matrix mOccsol, Matrix mCluster) {
        try {
            String csv = this.path + "cluster_" + this.distance + ".csv";
            ClusterOverlay co = new ClusterOverlay(this.interest, csv, mCluster, mOccsol);
            co.addObserver(this);
            MatrixManager.exportAsciiGrid(co.allRun(), this.path + "cluster_" + this.distance + ".asc");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
    }

    @Override
    public void updateProgression(Analysis a, int total) {
        this.updateProgression(this.gTotal);
    }
}

