/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.cluster;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.ChamferDistanceCalculation;
import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixCalculation;
import fr.inra.sad.bagap.apiland.analysis.matrix.RCMDistanceCalculation;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringQueen;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.GroupOverlay;
import fr.inra.sad.bagap.apiland.analysis.matrix.pixel.Pixel2PixelMatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import java.util.HashSet;
import java.util.List;

public class GroupDistanceAnalysis
extends MatrixAnalysis
implements AnalysisObserver {
    private double[] distances;
    private List<Integer> interest;
    private List<Double> minimumAreas;
    private double minimumTotal;
    private String path;
    private String name;
    private int gTotal;
    private Friction frictionMap;
    private Matrix frictionMat;

    public GroupDistanceAnalysis(Matrix m, double[] distances, List<Integer> interest, List<Double> minimumAreas, double minimumTotal, String path, String name, Friction frictionMap) {
        this(m, distances, interest, minimumAreas, minimumTotal, path, name);
        this.frictionMap = frictionMap;
    }

    public GroupDistanceAnalysis(Matrix m, double[] distances, List<Integer> interest, List<Double> minimumAreas, double minimumTotal, String path, String name, Matrix frictionMat) {
        this(m, distances, interest, minimumAreas, minimumTotal, path, name);
        this.frictionMat = frictionMat;
    }

    public GroupDistanceAnalysis(Matrix m, double[] distances, List<Integer> interest, List<Double> minimumAreas, double minimumTotal, String path, String name) {
        super(m);
        this.distances = distances;
        this.interest = interest;
        this.minimumAreas = minimumAreas;
        this.minimumTotal = minimumTotal;
        if (path == null || path.equalsIgnoreCase("")) {
            this.name = !name.endsWith(".asc") ? name + ".asc" : name;
        } else {
            this.path = !path.endsWith("/") ? path + "/" : path;
            this.name = name;
        }
        this.gTotal = this.frictionMap != null || this.frictionMat != null ? 3 * this.matrix().size() : 8 * this.matrix().size();
    }

    private double getMaxDistance() {
        double d = 0.0;
        for (double distance : this.distances) {
            d = Math.max(d, distance);
        }
        return d;
    }

    @Override
    protected void doRun() {
        try {
            Matrix mD = this.distance(this.matrix());
            for (double distance : this.distances) {
                Matrix mClassif = this.classification(this.matrix(), mD, distance);
                Matrix mCluster = this.cluster(mClassif);
                this.overlay(this.matrix(), mCluster, distance);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private Matrix distance(Matrix matrix) {
        MatrixCalculation cdistance = null;
        cdistance = this.frictionMap != null ? new RCMDistanceCalculation(matrix, this.frictionMap, this.interest, this.getMaxDistance() + 0.0) : (this.frictionMat != null ? new RCMDistanceCalculation(matrix, this.frictionMat, this.interest, this.getMaxDistance() + 0.0) : new ChamferDistanceCalculation(matrix, this.interest));
        cdistance.addObserver(this);
        Matrix d = cdistance.allRun();
        return d;
    }

    private Matrix accessibilite(Matrix mD, final double dMax) {
        try {
            Pixel2PixelMatrixCalculation accessibilite = new Pixel2PixelMatrixCalculation(new Matrix[]{mD}){

                @Override
                protected double treatPixel(Pixel p) {
                    double v = this.matrix().get(p);
                    if (v < dMax / 2.0) {
                        return dMax - v;
                    }
                    return 0.0;
                }
            };
            accessibilite.addObserver(this);
            Matrix m = accessibilite.allRun();
            MatrixManager.exportAsciiGrid(m, this.path + "test.asc");
            return m;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Matrix classification(final Matrix matrix, Matrix mD, final double distance) {
        try {
            Pixel2PixelMatrixCalculation classif = new Pixel2PixelMatrixCalculation(new Matrix[]{mD}){

                @Override
                protected double treatPixel(Pixel p) {
                    double v = this.matrix().get(p);
                    if (GroupDistanceAnalysis.this.interest.contains((int)matrix.get(p))) {
                        return 1.0;
                    }
                    if (v == (double)Raster.getNoDataValue()) {
                        return Raster.getNoDataValue();
                    }
                    if (v <= distance / 2.0) {
                        return 1.0;
                    }
                    return 0.0;
                }
            };
            classif.addObserver(this);
            Matrix m = classif.allRun();
            return m;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Matrix cluster(Matrix mClassif) {
        try {
            HashSet<Integer> vcluster = new HashSet<Integer>();
            vcluster.add(1);
            ClusteringQueen ca = null;
            ca = new ClusteringQueen(mClassif, vcluster);
            ca.addObserver(this);
            Matrix mCluster = (Matrix)ca.allRun();
            return mCluster;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void overlay(Matrix mOccsol, Matrix mCluster, double distance) {
        try {
            String csv = null;
            String ascii = null;
            if (this.path == null || this.path.equalsIgnoreCase("")) {
                csv = this.name.replace(".asc", ".csv");
                ascii = this.name;
            } else {
                String[] splitdistances = new Double(distance).toString().split("\\.");
                String d = splitdistances[0];
                csv = this.path + this.name + "_" + d + ".csv";
                ascii = this.path + this.name + "_" + d + ".asc";
            }
            GroupOverlay co = new GroupOverlay(this.interest, this.minimumAreas, this.minimumTotal, csv, mCluster, mOccsol);
            co.addObserver(this);
            Matrix m = co.allRun();
            MatrixManager.exportAsciiGrid(m, ascii);
            this.setResult(m);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
    }

    @Override
    public void updateProgression(Analysis a, int total) {
        this.updateProgression(this.gTotal);
    }
}

