/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.cluster;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Count;
import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixAnalysis;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class NewClusteringAnalysis
extends MatrixAnalysis {
    private Collection<Integer> interest;
    private String csv;
    private List<Double> minimumAreas;
    private double minimumTotal;
    private Map<Integer, Map<Integer, Count>> patchs;

    public NewClusteringAnalysis(Matrix m, Collection<Integer> interest, List<Double> minimumAreas, double minimumTotal, String outputFolder, String name) {
        super(m);
        this.interest = interest;
        this.csv = outputFolder + "/cluster_" + name + ".csv";
        this.minimumAreas = minimumAreas;
        this.minimumTotal = minimumTotal;
    }

    @Override
    protected void doRun() {
        RasterComposite r = new RasterComposite();
        TreeSet<Pixel> ever = new TreeSet<Pixel>();
        int oldy = -1;
        int index = 0;
        int total = this.matrix().width() * this.matrix().height();
        this.patchs = new TreeMap<Integer, Map<Integer, Count>>();
        for (Pixel p : this.matrix()) {
            if (p.y() > oldy) {
                Iterator ite = ever.iterator();
                while (ite.hasNext() && ((Pixel)ite.next()).y() == oldy) {
                    ite.remove();
                }
                oldy = p.y();
            }
            if (!ever.contains(p)) {
                ever.add(p);
                double v = this.matrix().get(p);
                if (v != (double)Raster.getNoDataValue() && (this.interest == null || this.interest.contains((int)v))) {
                    PixelComposite pc = this.diffuseFromPixel(this.matrix(), p, ever, new PixelComposite(p, ++index));
                    int vu = pc.getValue();
                    this.patchs.put(vu, new HashMap());
                    double totalv = 0.0;
                    for (Pixel pi : pc) {
                        int vv = (int)this.matrix(0).get(pi);
                        if (vv == 0 || vv == Raster.getNoDataValue()) continue;
                        if (!this.patchs.get(vu).containsKey(vv)) {
                            this.patchs.get(vu).put(vv, new Count());
                        }
                        this.patchs.get(vu).get(vv).add();
                        totalv += 1.0;
                    }
                    if (this.minimumTotal != -1.0) {
                        if (this.minimumTotal <= totalv * Math.pow(Raster.getCellSize(), 2.0) / 10000.0) {
                            r.addSimplePixelComposite(pc);
                        } else {
                            this.patchs.remove(vu);
                        }
                    } else {
                        r.addSimplePixelComposite(pc);
                    }
                }
            }
            this.updateProgression(total);
        }
        r = (RasterComposite)r.smooth();
        this.setResult(r);
    }

    private PixelComposite diffuseFromPixel(Matrix m, Pixel p, Set<Pixel> ever, PixelComposite pc) {
        LinkedList<Pixel> next = new LinkedList<Pixel>();
        next.add(p);
        while (!next.isEmpty()) {
            Pixel np = (Pixel)next.poll();
            this.treatPixel(m, np, ever, next);
            pc.addSimplePixel(np);
        }
        return pc;
    }

    private void treatPixel(Matrix m, Pixel p, Set<Pixel> ever, LinkedList<Pixel> next) {
        Iterator<Pixel> ite = this.getMargins(p);
        while (ite.hasNext()) {
            int v;
            Pixel np = ite.next();
            if (ever.contains(np) || !m.contains(np) || !this.interest.contains(v = (int)m.get(np))) continue;
            next.addLast(np);
            ever.add(np);
        }
    }

    public abstract Iterator<Pixel> getMargins(Pixel var1);

    @Override
    protected void doClose() {
        try {
            CsvWriter cw = new CsvWriter(this.csv);
            cw.setDelimiter(';');
            cw.write("id");
            cw.write("nb_pixels_patch");
            cw.write("surface_patch");
            Iterator<Object> iterator = this.interest.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                if (n == 0 || n == Raster.getNoDataValue()) continue;
                cw.write("nb_pixels_patch_" + n);
                cw.write("surface_patch_" + n);
                cw.write("rate_patch_" + n);
            }
            cw.endRecord();
            for (Map.Entry entry : this.patchs.entrySet()) {
                int vu = (Integer)entry.getKey();
                cw.write(vu + "");
                int nbpp = 0;
                for (int vM : this.interest) {
                    if (!((Map)entry.getValue()).containsKey(vM)) continue;
                    nbpp += this.patchs.get(vu).get(vM).get();
                }
                cw.write(nbpp + "");
                cw.write((double)nbpp * Math.pow(Raster.getCellSize(), 2.0) + "");
                int nbpsp = 0;
                for (int vM : this.interest) {
                    if (((Map)entry.getValue()).containsKey(vM)) {
                        nbpsp = this.patchs.get(vu).get(vM).get();
                        cw.write(nbpsp + "");
                        cw.write((double)nbpsp * Math.pow(Raster.getCellSize(), 2.0) + "");
                        cw.write((double)nbpsp * 100.0 / (double)nbpp + "");
                        continue;
                    }
                    cw.write("0");
                    cw.write("0.0");
                    cw.write("0.0");
                }
                cw.endRecord();
            }
            cw.close();
        }
        catch (CsvWriter.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }
}

