/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.MultipleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.SimpleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.CoordinateManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class GridCsvOutput
extends AbstractMetricOutput {
    private int size;
    private double decalage;
    private Matrix matrix;
    private CsvWriter out;
    private String file;
    private Map<String, Double> values;
    private boolean okValues;

    public GridCsvOutput(int size, Matrix m, String f) {
        this.size = size;
        this.decalage = (double)(m.height() % size) * Raster.getCellSize();
        this.matrix = m;
        this.file = f;
        this.values = new TreeMap<String, Double>();
        this.flush();
    }

    public String toString() {
        return "csv";
    }

    private void flush() {
        this.values.clear();
        this.okValues = false;
    }

    @Override
    public void notify(Metric m, String metric, double value, Process process) {
        this.values.put(metric, value);
        if (value != (double)Raster.getNoDataValue()) {
            this.okValues = true;
        }
    }

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)ma);
                break;
            }
            case RUNNING: {
                this.notifyAnalysisRun((WindowMatrixAnalysis)ma);
                break;
            }
            case FINISH: {
                this.notifyAnalysisFinish((WindowMatrixAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis a) {
        this.out = new CsvWriter(this.file);
        this.out.setDelimiter(';');
        if (a.window() instanceof MultipleWindow) {
            for (Window w : ((MultipleWindow)a.window()).windows()) {
                for (Metric metric : a.metrics()) {
                    this.values.put("w" + ((SimpleWindow)w).diameter() + "_" + metric.getName(), -9999.0);
                }
            }
        } else {
            for (Metric metric : a.metrics()) {
                this.values.put(metric.getName(), -9999.0);
            }
        }
    }

    private void notifyAnalysisRun(WindowMatrixAnalysis a) {
        try {
            this.out.write("X");
            this.out.write("Y");
            for (String v : this.values.keySet()) {
                this.out.write(v);
            }
            this.out.endRecord();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyAnalysisFinish(WindowMatrixAnalysis a) {
        this.out.close();
        this.out = null;
        this.values.clear();
        this.values = null;
        this.matrix = null;
    }

    @Override
    public void notify(Process p, ProcessState s) {
        switch (s) {
            case DONE: {
                this.notifyProcessDone((WindowMatrixProcess)p);
            }
        }
    }

    private void notifyProcessDone(WindowMatrixProcess wp) {
        try {
            if (this.okValues) {
                this.out.write(CoordinateManager.getProjectedX(this.matrix, wp.x()) - Raster.getCellSize() / 2.0 + (double)this.size / 2.0 * Raster.getCellSize() + "");
                this.out.write(CoordinateManager.getProjectedY(this.matrix, wp.y()) + Raster.getCellSize() / 2.0 - (double)this.size / 2.0 * Raster.getCellSize() + "");
                for (String v : this.values.keySet()) {
                    this.out.write(this.format(this.values.get(v)));
                }
                this.out.endRecord();
            }
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.flush();
    }
}

