/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class HeaderDeltaAsciiGridOutputBis
extends AbstractMetricOutput {
    private String ascii;
    private int delta;
    private int xOrigin;
    private int yOrigin;

    public HeaderDeltaAsciiGridOutputBis(String output, int delta, int xOrigin, int yOrigin) {
        this.ascii = output;
        this.delta = delta;
        this.xOrigin = xOrigin;
        this.yOrigin = yOrigin;
    }

    public String toString() {
        return "ascii_header";
    }

    @Override
    public void notify(Analysis a, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)a);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis wa) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.ascii));
            int width = wa.matrix().width() - this.xOrigin;
            int height = wa.matrix().height() - this.yOrigin;
            int nc = width / this.delta;
            if (width % this.delta != 0) {
                ++nc;
            }
            int nr = new Double(height / this.delta).intValue();
            if (height % this.delta != 0) {
                ++nr;
            }
            double xdecalage = (double)(this.delta - 1) * Raster.getCellSize() / 2.0 - (double)this.xOrigin * Raster.getCellSize();
            double ydecalage = (double)(this.delta - 1) * Raster.getCellSize() / 2.0 - (double)this.yOrigin * Raster.getCellSize();
            double mod = ((double)wa.matrix().height() * Raster.getCellSize() + ydecalage) % ((double)this.delta * Raster.getCellSize());
            writer.write("ncols " + nc);
            writer.newLine();
            writer.write("nrows " + nr);
            writer.newLine();
            writer.write("xllcorner " + (wa.matrix().minX() - xdecalage));
            writer.newLine();
            if (mod == 0.0) {
                writer.write("yllcorner " + wa.matrix().minY());
            } else if (mod >= (double)this.delta * Raster.getCellSize() / 2.0) {
                writer.write("yllcorner " + (wa.matrix().minY() - ((double)this.delta * Raster.getCellSize() - mod)));
            } else {
                writer.write("yllcorner " + (wa.matrix().minY() + mod));
            }
            writer.newLine();
            writer.write("cellsize " + (double)this.delta * wa.matrix().cellsize());
            writer.newLine();
            writer.write("NODATA_value " + Raster.getNoDataValue());
            writer.newLine();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void notify(Metric m, String metric, double v, Process wp) {
        m.removeObserver(this);
    }
}

