/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.MatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.SimpleWindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetric;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.analysis.process.metric.DistanceValueMetric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.util.Couple;
import fr.inra.sad.bagap.apiland.core.util.DistanceValueMatrix;
import java.io.File;
import java.io.IOException;

public class WindowMatrixProcessType
extends MatrixProcessType {
    private double[] verticals;
    private double[] horizontals;
    private double hc;
    private double vc;

    public WindowMatrixProcessType(boolean distanceType, Matrix m) {
        super(distanceType, m);
        this.horizontals = new double[m.width()];
        for (int x = 0; x < m.width(); ++x) {
            this.horizontals[x] = Raster.getNoDataValue();
        }
        this.verticals = new double[m.height()];
        for (int y = 0; y < m.height(); ++y) {
            this.verticals[y] = Raster.getNoDataValue();
        }
    }

    public WindowMatrixProcessType(Matrix m) {
        this(false, m);
    }

    public WindowMatrixProcess create(Window w, Pixel p) {
        return new SimpleWindowMatrixProcess(w, p, this);
    }

    public WindowMatrixProcess create(Window w, Pixel p, boolean selected) {
        return this.create(w, p);
    }

    public void setValue(int x, int y, double v, Matrix m) {
        this.vc = Couple.get(v, this.horizontals[x]);
        this.horizontals[x] = v;
        this.hc = Couple.get(v, this.verticals[y]);
        this.verticals[y] = v;
    }

    public double getHorizontal(Matrix m) {
        return this.hc;
    }

    public double getVertical(Matrix m) {
        return this.vc;
    }

    @Override
    public void addMetric(MatrixMetric wm) {
        super.addMetric(wm);
        if (wm instanceof DistanceValueMetric) {
            File f = new File(this.matrix().getFile());
            String distanceMatrixFile = f.getParent() + "/" + f.getName().replace(".asc", "") + ".distance";
            try {
                CsvReader cr = new CsvReader(distanceMatrixFile);
                cr.setDelimiter(';');
                cr.readHeaders();
                DistanceValueMatrix dvm = new DistanceValueMatrix();
                while (cr.readRecord()) {
                    for (int v : this.matrix().values()) {
                        if (v == 0 || v == Raster.getNoDataValue()) continue;
                        dvm.setDistance(Integer.parseInt(cr.get("distance")), v, Double.parseDouble(cr.get(v + "")));
                    }
                }
                cr.close();
                ((DistanceValueMetric)((Object)wm)).setDistanceMatrix(dvm);
            }
            catch (CsvReader.CatastrophicException | CsvReader.FinalizedException | IOException e) {
                e.printStackTrace();
            }
        }
    }
}

