/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.distance;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingDecorator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;

public class ValueDistanceCounting
extends CountingDecorator {
    private int size;
    private int[][] datas;
    private Map<Integer, Double> values;
    private Map<Integer, Double> countClass;
    private boolean calculated;

    public ValueDistanceCounting(Counting decorate, int size) {
        super(decorate);
        this.size = size;
    }

    @Override
    protected void doInit() {
        this.datas = new int[this.size][this.size];
        for (int j = 0; j < this.size; ++j) {
            Arrays.fill(this.datas[j], 0);
        }
        this.values = new TreeMap<Integer, Double>();
        this.countClass = new TreeMap<Integer, Double>();
        this.calculated = false;
    }

    @Override
    protected void doDown(int d, int place) {
        int[] tnewFill = new int[this.size];
        Arrays.fill(tnewFill, 0);
        this.datas = (int[][])Arrays.copyOfRange(this.datas, 1, this.datas.length);
        this.datas = (int[][])ArrayUtils.addAll((Object[])this.datas, (Object[])new int[][]{tnewFill});
        this.calculated = false;
    }

    @Override
    protected void doAdd(double value, int x, int y, int filter, double ch, double cv) {
        this.doAddValue(value, x, y);
    }

    @Override
    protected void doAddValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue() && value != 0.0) {
            this.datas[y][x] = (int)value;
        }
    }

    @Override
    protected void doRemoveValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue() && value != 0.0) {
            this.datas[y][x] = 0;
        }
    }

    @Override
    public void doDelete() {
        this.datas = null;
        this.values.clear();
        this.values = null;
        this.countClass.clear();
        this.countClass = null;
    }

    private void calculate() {
        this.values.clear();
        this.countClass.clear();
        for (int j = 0; j < this.size; ++j) {
            for (int i = 0; i < this.size; ++i) {
                double v = this.datas[j][i];
                if (!(v > 0.0)) continue;
                if (!this.values.containsKey((int)v)) {
                    this.values.put((int)v, 0.0);
                    this.countClass.put((int)v, (Double)Double.MIN_VALUE);
                }
                double weight = this.process().window().weighted()[j][i];
                this.values.put((int)v, this.values.get((int)v) + weight);
                if (!(this.countClass.get((int)v) < weight)) continue;
                this.countClass.put((int)v, weight);
            }
        }
        for (Map.Entry<Integer, Double> e : this.values.entrySet()) {
            if (!(e.getValue() < 0.0)) continue;
            this.values.put(e.getKey(), 0.0);
        }
        this.calculated = true;
    }

    @Override
    public Set<Integer> values() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.values.keySet();
    }

    @Override
    public double countValue(int v) {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.values.containsKey(v)) {
            return this.values.get(v);
        }
        return 0.0;
    }

    @Override
    public double countClass() {
        if (!this.calculated) {
            this.calculate();
        }
        double c = 0.0;
        for (Double v : this.countClass.values()) {
            c += v.doubleValue();
        }
        return c;
    }
}

