/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.threshold;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingDecorator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.util.Couple;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CoupleCounting
extends CountingDecorator {
    private int totalCouples;
    private int validCouples;
    private int countCouples;
    private int homogeneousCouples;
    private int heterogeneousCouples;
    private Map<Double, Counting.Count> countC;

    public CoupleCounting(Counting decorate) {
        super(decorate);
    }

    @Override
    public Set<Double> couples() {
        return this.countC.keySet();
    }

    @Override
    public double totalCouples() {
        return this.totalCouples;
    }

    @Override
    public double validCouples() {
        return this.validCouples;
    }

    @Override
    public double countCouples() {
        return this.countCouples;
    }

    @Override
    public double homogeneousCouples() {
        return this.homogeneousCouples;
    }

    @Override
    public double heterogeneousCouples() {
        return this.heterogeneousCouples;
    }

    @Override
    public double countCouple(double c) {
        if (this.countC.containsKey(c)) {
            return this.countC.get(c).get();
        }
        return 0.0;
    }

    @Override
    public void doInit() {
        this.totalCouples = 0;
        this.validCouples = 0;
        this.countCouples = 0;
        this.countC = new TreeMap<Double, Counting.Count>();
    }

    @Override
    protected void doAdd(double value, int x, int y, int filter, double ch, double cv) {
        if (filter != 4) {
            if (filter != 3) {
                ++this.totalCouples;
                if (ch != (double)Raster.getNoDataValue()) {
                    ++this.validCouples;
                    if (ch != 0.0) {
                        ++this.countCouples;
                        if (!this.countC.containsKey(ch)) {
                            this.countC.put(ch, new Counting.Count());
                        }
                        this.countC.get(ch).add();
                        if (Couple.isHomogeneous(ch)) {
                            ++this.homogeneousCouples;
                        } else {
                            ++this.heterogeneousCouples;
                        }
                    }
                }
            }
            if (filter != 2) {
                ++this.totalCouples;
                if (cv != (double)Raster.getNoDataValue()) {
                    ++this.validCouples;
                    if (cv != 0.0) {
                        ++this.countCouples;
                        if (!this.countC.containsKey(cv)) {
                            this.countC.put(cv, new Counting.Count());
                        }
                        this.countC.get(cv).add();
                        if (Couple.isHomogeneous(cv)) {
                            ++this.homogeneousCouples;
                        } else {
                            ++this.heterogeneousCouples;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void doAddCouple(double couple, int x1, int y1, int x2, int y2) {
        ++this.totalCouples;
        if (couple != (double)Raster.getNoDataValue()) {
            ++this.validCouples;
            if (couple != 0.0) {
                ++this.countCouples;
                if (!this.countC.containsKey(couple)) {
                    this.countC.put(couple, new Counting.Count());
                }
                this.countC.get(couple).add();
                if (Couple.isHomogeneous(couple)) {
                    ++this.homogeneousCouples;
                } else {
                    ++this.heterogeneousCouples;
                }
            }
        }
    }

    @Override
    protected void doRemoveCouple(double couple, int x1, int y1, int x2, int y2) {
        --this.totalCouples;
        if (couple != (double)Raster.getNoDataValue()) {
            --this.validCouples;
            if (couple != 0.0) {
                --this.countCouples;
                this.countC.get(couple).minus();
                if (this.countC.get(couple).get() == 0) {
                    this.countC.remove(couple);
                }
                if (Couple.isHomogeneous(couple)) {
                    --this.homogeneousCouples;
                } else {
                    --this.heterogeneousCouples;
                }
            }
        }
    }

    @Override
    public void doDelete() {
        this.countC.clear();
        this.countC = null;
    }

    @Override
    protected void doDown(int d, int place) {
        int outy;
        int outx;
        for (Pixel p : this.process().window().removeHorizontalDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width()) continue;
            this.process().counting().removeCouple(Couple.get(this.process().values()[p.y()][p.x() - 1], this.process().values()[p.y()][p.x()]), 0, 0, 0, 0);
        }
        for (Pixel p : this.process().window().addHorizontalDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width() || p.y() >= this.process().window().diameter() - d + place) continue;
            this.process().counting().addCouple(Couple.get(this.process().values()[p.y()][p.x() - 1], this.process().values()[p.y()][p.x()]), 0, 0, 0, 0);
        }
        for (Pixel p : this.process().window().removeVerticalDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width()) continue;
            this.process().counting().removeCouple(Couple.get(this.process().values()[p.y() - 1][p.x()], this.process().values()[p.y()][p.x()]), 0, 0, 0, 0);
        }
        for (Pixel p : this.process().window().addVerticalDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width() || p.y() >= this.process().window().diameter() - d + place) continue;
            this.process().counting().addCouple(Couple.get(this.process().values()[p.y() - 1][p.x()], this.process().values()[p.y()][p.x()]), 0, 0, 0, 0);
        }
    }
}

