/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.threshold;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingDecorator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class FullQuantitativeCounting
extends CountingDecorator {
    private final int size;
    private double min;
    private double max;
    private double[][] datas;

    public FullQuantitativeCounting(Counting decorate, int size) {
        super(decorate);
        this.size = size;
    }

    @Override
    public double getMaximum() {
        if (this.max != -1.7976931348623157E308) {
            return this.max;
        }
        return Raster.getNoDataValue();
    }

    @Override
    public double getMinimum() {
        if (this.min != Double.MAX_VALUE) {
            return this.min;
        }
        return Raster.getNoDataValue();
    }

    @Override
    public double getTruncatedAverage(double threshold) {
        double value = 0.0;
        int count = 0;
        double v2 = 0.0;
        for (int j = 0; j < this.size; ++j) {
            for (int i = 0; i < this.size; ++i) {
                double v = this.datas[j][i];
                if (v == (double)Raster.getNoDataValue()) continue;
                ++count;
                if (v <= threshold) {
                    v2 += v / threshold;
                    continue;
                }
                v2 += 1.0;
            }
        }
        value = count == 0 ? 0.0 : v2 / (double)count;
        return value;
    }

    @Override
    protected void doInit() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.datas = new double[this.size][this.size];
        for (int j = 0; j < this.size; ++j) {
            for (int i = 0; i < this.size; ++i) {
                this.datas[j][i] = Raster.getNoDataValue();
            }
        }
    }

    @Override
    protected void doDown(int d, int place) {
        double[] tnewFill = new double[this.size];
        Arrays.fill(tnewFill, (double)Raster.getNoDataValue());
        this.datas = (double[][])Arrays.copyOfRange(this.datas, 1, this.datas.length);
        this.datas = (double[][])ArrayUtils.addAll((Object[])this.datas, (Object[])new double[][]{tnewFill});
    }

    @Override
    protected void doAdd(double value, int x, int y, int filter, double ch, double cv) {
        this.doAddValue(value, x, y);
    }

    @Override
    protected void doAddValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            this.datas[y][x] = value;
        }
    }

    @Override
    public void doRemoveValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            double v;
            int i;
            int j;
            this.datas[y][x] = Raster.getNoDataValue();
            if (this.min == value) {
                this.min = Double.MAX_VALUE;
                for (j = 0; j < this.size; ++j) {
                    for (i = 0; i < this.size; ++i) {
                        v = this.datas[j][i];
                        if (v == (double)Raster.getNoDataValue()) continue;
                        this.min = Math.min(this.min, v);
                    }
                }
            }
            if (this.max == value) {
                this.max = -1.7976931348623157E308;
                for (j = 0; j < this.size; ++j) {
                    for (i = 0; i < this.size; ++i) {
                        v = this.datas[j][i];
                        if (v == (double)Raster.getNoDataValue()) continue;
                        this.max = Math.max(this.max, v);
                    }
                }
            }
        }
    }

    @Override
    protected void doDelete() {
        this.datas = null;
    }
}

