/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.threshold;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingDecorator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.patch.Patch;
import fr.inra.sad.bagap.apiland.patch.PatchComposite;
import java.util.HashMap;

public class PatchCountingOld
extends CountingDecorator {
    private PatchComposite patches;

    public PatchCountingOld(Counting decorate) {
        super(decorate);
    }

    @Override
    protected void doDown(int d, int place) {
        this.patches.upPixels();
    }

    @Override
    protected void doAdd(double value, int x, int y, int filter, double ch, double cv) {
        this.doAddValue(value, x, y);
    }

    @Override
    protected void doAddValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            this.patches.addPixel(new Pixel(x, y), (int)value);
        }
    }

    @Override
    protected void doRemoveValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            this.patches.removePixel(new Pixel(x, y), (int)value);
        }
    }

    @Override
    protected void doInit() {
        this.patches = new PatchComposite();
    }

    @Override
    protected void doDelete() {
        this.patches = null;
    }

    @Override
    public PatchComposite patches() {
        return this.patches;
    }

    @Override
    public double getPatchNumber() {
        int nb = 0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() == 0) continue;
            ++nb;
        }
        return nb;
    }

    @Override
    public double getPatchNumber(int classe) {
        int nb = 0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() != classe) continue;
            ++nb;
        }
        return nb;
    }

    @Override
    public double getLargestPatchSize() {
        double value = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() == 0) continue;
            value = Math.max(value, p.getArea());
        }
        return value /= 10000.0;
    }

    @Override
    public double getLargestPatchSize(int classe) {
        double value = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() != classe) continue;
            value = Math.max(value, p.getArea());
        }
        return value /= 10000.0;
    }

    @Override
    public double getMeanPatchSize() {
        double value = 0.0;
        double count = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() == 0) continue;
            value += p.getArea();
            count += 1.0;
        }
        value = count == 0.0 ? 0.0 : (value /= count);
        return value;
    }

    @Override
    public double getMeanPatchSize(int classe) {
        double value = 0.0;
        double count = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() != classe) continue;
            value += p.getArea();
            count += 1.0;
        }
        value = count == 0.0 ? 0.0 : (value /= count);
        return value;
    }

    @Override
    public double getShannonDiversityPatchSize() {
        double area;
        HashMap<Patch, Double> areas = new HashMap<Patch, Double>();
        double sum = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() == 0) continue;
            area = p.getArea() / 10000.0;
            areas.put(p, area);
            sum += area;
        }
        double value = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() == 0) continue;
            area = (Double)areas.get(p);
            value += area / sum * Math.log(area / sum);
        }
        if (value != 0.0) {
            value *= -1.0;
        }
        return value;
    }

    @Override
    public double getShannonDiversityPatchSize(int classe) {
        double area;
        HashMap<Patch, Double> areas = new HashMap<Patch, Double>();
        double sum = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() != classe) continue;
            area = p.getArea() / 10000.0;
            areas.put(p, area);
            sum += area;
        }
        double value = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() != classe) continue;
            area = (Double)areas.get(p);
            value += area / sum * Math.log(area / sum);
        }
        if (value != 0.0) {
            value *= -1.0;
        }
        return value;
    }
}

