/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.threshold;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingDecorator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;

public class QuantitativeCounting
extends CountingDecorator {
    private int nb;
    private int nbPos;
    private int nbNeg;
    private double sum;
    private double squaresum;

    public QuantitativeCounting(Counting decorate) {
        super(decorate);
    }

    @Override
    public double getSum() {
        if (this.size() == 0.0) {
            return Raster.getNoDataValue();
        }
        if (this.sum < 1.0E-6 && this.sum > -1.0E-6) {
            this.sum = 0.0;
        }
        return this.sum;
    }

    @Override
    public double getSquareSum() {
        if (this.size() == 0.0) {
            return Raster.getNoDataValue();
        }
        return this.squaresum;
    }

    @Override
    public double countPositives() {
        if (this.size() == 0.0) {
            return Raster.getNoDataValue();
        }
        return this.nbPos;
    }

    @Override
    public double countNegatives() {
        if (this.size() == 0.0) {
            return Raster.getNoDataValue();
        }
        return this.nbNeg;
    }

    @Override
    public double size() {
        return this.nb;
    }

    @Override
    public double getVariance() {
        if (this.size() < 2.0) {
            return Raster.getNoDataValue();
        }
        return this.getSquareSum() / this.size() - this.getAverage() * this.getAverage();
    }

    @Override
    public double getAverage() {
        if (this.size() == 0.0) {
            return Raster.getNoDataValue();
        }
        return this.getSum() / this.size();
    }

    @Override
    public double getStandardDeviation() {
        if (this.size() < 2.0) {
            return Raster.getNoDataValue();
        }
        return Math.sqrt(this.getVariance());
    }

    @Override
    public double getStandardError() {
        if (this.size() < 2.0) {
            return Raster.getNoDataValue();
        }
        return this.getStandardDeviation() / Math.sqrt(this.size());
    }

    @Override
    public double getVariationCoefficient() {
        if (this.size() < 2.0) {
            return Raster.getNoDataValue();
        }
        double a = this.getAverage();
        if (a == 0.0 || a == 0.0) {
            return Raster.getNoDataValue();
        }
        double st = this.getStandardDeviation();
        if (Double.isNaN(st)) {
            return Raster.getNoDataValue();
        }
        if (st == 0.0) {
            return 0.0;
        }
        return 100.0 * st / a;
    }

    @Override
    public void doInit() {
        this.nb = 0;
        this.sum = 0.0;
        this.squaresum = 0.0;
        this.nbPos = 0;
        this.nbNeg = 0;
    }

    @Override
    public void doAdd(double value, int x, int y, int filter, double ch, double cv) {
        this.doAddValue(value, x, y);
    }

    @Override
    protected void doAddValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            if (value > 0.0) {
                ++this.nbPos;
            } else if (value < 0.0) {
                ++this.nbNeg;
            }
            ++this.nb;
            this.sum += value;
            this.squaresum += value * value;
        }
    }

    @Override
    public void doRemoveValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            if (value > 0.0) {
                --this.nbPos;
            } else if (value < 0.0) {
                --this.nbNeg;
            }
            --this.nb;
            this.sum -= value;
            this.squaresum -= value * value;
        }
    }

    @Override
    public void doDelete() {
    }
}

