/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.threshold;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingDecorator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ValueCounting
extends CountingDecorator {
    private Map<Integer, Counting.Count> countV;

    public ValueCounting(Counting decorate) {
        super(decorate);
    }

    @Override
    public void doInit() {
        this.countV = new TreeMap<Integer, Counting.Count>();
    }

    @Override
    public void doAdd(double value, int x, int y, int filter, double ch, double cv) {
        this.doAddValue(value, x, y);
    }

    @Override
    protected void doAddValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue() && value != 0.0) {
            if (!this.countV.containsKey((int)value)) {
                this.countV.put((int)value, new Counting.Count());
            }
            this.countV.get((int)value).add();
        }
    }

    @Override
    protected void doRemoveValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue() && value != 0.0) {
            this.countV.get((int)value).minus();
            if (this.countV.get((int)value).get() == 0) {
                this.countV.remove((int)value);
            }
        }
    }

    @Override
    public void doDelete() {
        this.countV.clear();
        this.countV = null;
    }

    @Override
    public Set<Integer> values() {
        return this.countV.keySet();
    }

    @Override
    public double countValue(int v) {
        if (this.countV.containsKey(v)) {
            return this.countV.get(v).get();
        }
        return 0.0;
    }

    @Override
    public double countClass() {
        return this.countV.size();
    }
}

