/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.qualitative.couple;

import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.SimpleWindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.CoupleMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.ValueMetric;

public class ContagionMetric
extends MatrixMetric
implements ValueMetric,
CoupleMetric {
    private int countValues = -1;

    public ContagionMetric() {
        super(VariableManager.get("CONTAG"));
    }

    @Override
    protected void doCalculate(Counting co) {
        if (this.countValues < 0) {
            this.countValues = ((SimpleWindowMatrixProcess)co.process()).processType().matrix().values().size();
            if (((SimpleWindowMatrixProcess)co.process()).processType().matrix().values().contains(0)) {
                --this.countValues;
            }
        }
        if (co.countCouples() > 0.0) {
            this.value = 0.0;
            for (int v : co.values()) {
                double pv = co.countValue(v) / co.validValues();
                if (pv == 0.0) continue;
                for (double c : co.couples()) {
                    double pc = co.countCouple(c) / co.validCouples();
                    if (pc == 0.0) continue;
                    this.value += pv * pc * Math.log(pv * pc);
                }
            }
            this.value = (1.0 + this.value / (2.0 * Math.log(this.countValues))) * 100.0;
        }
    }
}

