/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.qualitative.couple;

import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.SimpleWindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.CoupleMetric;
import fr.inra.sad.bagap.apiland.core.util.Couple;

public class NormalizedHeterogeneityStrictIndex
extends MatrixMetric
implements CoupleMetric {
    private int countCouplesHomo = -1;
    private int countCouplesHete = -1;

    public NormalizedHeterogeneityStrictIndex() {
        super(VariableManager.get("NHET-strict"));
    }

    @Override
    public void doCalculate(Counting co) {
        if (this.countCouplesHomo < 0) {
            int countValues = ((SimpleWindowMatrixProcess)co.process()).processType().matrix().values().size();
            if (((SimpleWindowMatrixProcess)co.process()).processType().matrix().values().contains(0)) {
                --countValues;
            }
            this.countCouplesHomo = countValues;
            for (int i = 0; i < countValues; ++i) {
                for (int j = i + 1; j < countValues; ++j) {
                    ++this.countCouplesHete;
                }
            }
        }
        if (co.countCouples() > 0.0) {
            double valueHomo = 0.0;
            double valueHete = 0.0;
            for (double c : co.couples()) {
                double p;
                if (!Couple.isHomogeneous(c)) {
                    p = co.countCouple(c) / co.heterogeneousCouples();
                    if (p == 0.0) continue;
                    valueHete += p * Math.log(p);
                    continue;
                }
                p = co.countCouple(c) / co.homogeneousCouples();
                if (p == 0.0) continue;
                valueHomo += p * Math.log(p);
            }
            if (valueHomo != 0.0) {
                valueHomo *= -1.0;
            }
            if (valueHete != 0.0) {
                valueHete *= -1.0;
            }
            double maxHomo = -1.0 * Math.log(1.0 / (double)this.countCouplesHomo);
            double maxHete = -1.0 * Math.log(1.0 / (double)this.countCouplesHete);
            this.value = ((valueHomo /= maxHomo) + (valueHete /= maxHete)) / 2.0;
        }
    }
}

