/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.util;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.manager.Tool;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.sql.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedLineString;
import org.locationtech.jts.geom.prep.PreparedPoint;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class ExportAsciiGridFromMultipleShapefileAnalysis
extends Analysis {
    private String ascii;
    private String[] shapes;
    private String attribute;
    private double cellsize;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private Map<String, String> map;

    public ExportAsciiGridFromMultipleShapefileAnalysis(String ascii, String[] shapes, String attribute, double cellsize, Map<String, String> map) {
        this.ascii = ascii;
        this.shapes = shapes;
        this.attribute = attribute;
        this.cellsize = cellsize;
        this.minX = Double.MAX_VALUE;
        this.maxX = -9.99999999E8;
        this.minY = Double.MAX_VALUE;
        this.maxY = -9.99999999E8;
        for (String shape : shapes) {
            double[] envelope = this.getEnvelopeFromShapefile(this.getShape(shape));
            this.minX = Math.min(this.minX, envelope[0]);
            this.maxX = Math.max(this.maxX, envelope[1]);
            this.minY = Math.min(this.minY, envelope[2]);
            this.maxY = Math.max(this.maxY, envelope[3]);
        }
        this.map = map;
    }

    public ExportAsciiGridFromMultipleShapefileAnalysis(String ascii, String[] shapes, String attribute, double cellsize, double minX, double maxX, double minY, double maxY, Map<String, String> map) {
        this.ascii = ascii;
        this.shapes = shapes;
        this.attribute = attribute;
        this.cellsize = cellsize;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.map = map;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doRun() {
        this.runLotGeometries();
    }

    protected void runLotGeometries() {
        ShpFiles[] sfs = new ShpFiles[this.shapes.length];
        int[] pos = new int[this.shapes.length];
        ShapeType[] types = new ShapeType[this.shapes.length];
        int nb = 0;
        for (int i = 0; i < this.shapes.length; ++i) {
            sfs[i] = this.getShape(this.shapes[i]);
            pos[i] = this.getAttributePosition(sfs[i], this.attribute);
            types[i] = this.getShapeType(sfs[i]);
            int max = this.getNumGeometries(sfs[i]);
            nb = Math.max(max, nb);
        }
        int ncols = (this.maxX - this.minX) % this.cellsize == 0.0 ? new Double(Math.floor((this.maxX - this.minX) / this.cellsize)).intValue() : new Double(Math.floor((this.maxX - this.minX) / this.cellsize) + 1.0).intValue();
        int nrows = (this.maxY - this.minY) % this.cellsize == 0.0 ? new Double(Math.floor((this.maxY - this.minY) / this.cellsize)).intValue() : new Double(Math.floor((this.maxY - this.minY) / this.cellsize) + 1.0).intValue();
        Geometry current = null;
        int decoup = nb / 1000000 + 1;
        int d = -1;
        double yorigin = (this.maxY - this.minY) % this.cellsize == 0.0 ? this.minY + Math.floor((this.maxY - this.minY) / this.cellsize) * this.cellsize : this.minY + (Math.floor((this.maxY - this.minY) / this.cellsize) + 1.0) * this.cellsize;
        PreparedPoint pp = null;
        try {
            pp = new PreparedPoint((Puntal)new WKTReader().read("POINT (0 0)"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.ascii));
            bw.write("ncols " + ncols);
            bw.newLine();
            bw.write("nrows " + nrows);
            bw.newLine();
            bw.write("xllcorner " + this.minX);
            bw.newLine();
            bw.write("yllcorner " + this.minY);
            bw.newLine();
            bw.write("cellsize " + this.cellsize);
            bw.newLine();
            bw.write("NODATA_value " + Raster.getNoDataValue());
            bw.newLine();
            int delta = 1000;
            STRtree[] spatialIndexes = new STRtree[this.shapes.length];
            for (int j = 0; j < nrows; ++j) {
                double y;
                if (j * decoup / nrows != d) {
                    d = j * decoup / nrows;
                    for (int s = 0; s < sfs.length; ++s) {
                        spatialIndexes[s] = this.getSpatialIndex(sfs[s], pos[s], this.map, new Envelope(this.minX - (double)delta, this.maxX + (double)delta, this.minY - (double)delta + (double)(decoup - d - 1) * ((this.maxY - this.minY) / (double)decoup), this.maxY + (double)delta - (double)d * (this.maxY - this.minY) / (double)decoup));
                    }
                }
                double x = this.minX + this.cellsize / 2.0;
                pp.getGeometry().getCoordinate().y = y = yorigin - this.cellsize / 2.0 - (double)j * this.cellsize;
                double distance = Math.sqrt(2.0) * this.cellsize / 2.0;
                for (int i = 0; i < ncols; ++i) {
                    pp.getGeometry().getCoordinate().x = x = this.minX + this.cellsize / 2.0 + (double)i * this.cellsize;
                    pp.getGeometry().geometryChanged();
                    if (current != null && pp.intersects(current)) {
                        bw.write(current.getUserData() + " ");
                    } else {
                        current = null;
                        boolean ok = false;
                        for (int s = 0; s < sfs.length; ++s) {
                            List geometries = spatialIndexes[s].query(new Envelope(new Coordinate(x - distance, y + distance), new Coordinate(x + distance, y - distance)));
                            for (Geometry g : geometries) {
                                if (types[s].isPolygonType() && pp.intersects(g)) {
                                    current = g;
                                    bw.write(g.getUserData() + " ");
                                    ok = true;
                                    break;
                                }
                                if (!types[s].isLineType() || !(pp.getGeometry().distance(g) <= distance)) continue;
                                bw.write(g.getUserData() + " ");
                                ok = true;
                                break;
                            }
                            if (ok) break;
                        }
                        if (!ok) {
                            bw.write(Raster.getNoDataValue() + " ");
                        }
                    }
                    this.updateProgression(nrows * ncols);
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void doClose() {
        try {
            Tool.copy(DynamicLayerFactory.class.getResourceAsStream("lambert93.prj"), this.ascii.replace(".asc", "") + ".prj");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.ascii = null;
        this.shapes = null;
        this.attribute = null;
        this.map = null;
    }

    private ShpFiles getShape(String shape) {
        try {
            ShpFiles sf = shape.endsWith(".shp") ? new ShpFiles(shape) : new ShpFiles(shape + ".shp");
            return sf;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException();
        }
    }

    private int getNumGeometries(ShpFiles sf) {
        try {
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            int size = 0;
            while (sfr.hasNext()) {
                GeometryCollection gc = (GeometryCollection)sfr.nextRecord().shape();
                if (gc == null) continue;
                size += gc.getNumGeometries();
            }
            sfr.close();
            return size;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private ShapeType getShapeType(ShpFiles sf) {
        try {
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            ShapeType type = sfr.getHeader().getShapeType();
            sfr.close();
            return type;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private int getAttributePosition(ShpFiles sf, String attribute) {
        try {
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (!dfh.getFieldName(f).equalsIgnoreCase(attribute)) continue;
                dfr.close();
                return f;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private double[] getEnvelopeFromShapefile(ShpFiles sf) {
        try {
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            ShapefileHeader sfh = sfr.getHeader();
            double[] envelope = new double[]{sfh.minX(), sfh.maxX(), sfh.minY(), sfh.maxY()};
            sfr.close();
            return envelope;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private Set<Geometry> getGeometries(ShpFiles sf, ShapeType type, int pos, Map<String, String> map) {
        try {
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            HashSet<Geometry> set = new HashSet<Geometry>();
            while (sfr.hasNext()) {
                dfr.read();
                GeometryCollection gc = (GeometryCollection)sfr.nextRecord().shape();
                if (gc == null) continue;
                for (int n = 0; n < gc.getNumGeometries(); ++n) {
                    Geometry g = gc.getGeometryN(n);
                    if (map == null) {
                        g.setUserData(dfr.readField(pos));
                    } else {
                        Object f = dfr.readField(pos);
                        if (map.containsKey(f + "")) {
                            g.setUserData((Object)map.get(f + ""));
                        } else {
                            g.setUserData(f);
                        }
                    }
                    set.add(g);
                }
            }
            sfr.close();
            dfr.close();
            return set;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private Set<PreparedGeometry> getPreparedGeometries(ShpFiles sf, ShapeType type, int pos, Map<String, String> map) {
        try {
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            HashSet<PreparedGeometry> set = new HashSet<PreparedGeometry>();
            while (sfr.hasNext()) {
                dfr.read();
                GeometryCollection gc = (GeometryCollection)sfr.nextRecord().shape();
                if (gc == null) continue;
                for (int n = 0; n < gc.getNumGeometries(); ++n) {
                    Geometry g = gc.getGeometryN(n);
                    if (map == null) {
                        g.setUserData(dfr.readField(pos));
                    } else {
                        Object f = dfr.readField(pos);
                        if (map.containsKey(f + "")) {
                            g.setUserData((Object)map.get(f + ""));
                        } else {
                            g.setUserData(f);
                        }
                    }
                    if (type.isLineType()) {
                        set.add((PreparedGeometry)new PreparedLineString((Lineal)g));
                        continue;
                    }
                    if (type.isPolygonType()) {
                        set.add((PreparedGeometry)new PreparedPolygon((Polygonal)g));
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
            }
            sfr.close();
            dfr.close();
            return set;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private STRtree getSpatialIndex(ShpFiles sf, int pos, Map<String, String> map, Envelope env) {
        try {
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            STRtree spatialIndex = new STRtree();
            while (sfr.hasNext()) {
                dfr.read();
                GeometryCollection gc = (GeometryCollection)sfr.nextRecord().shape();
                if (gc == null) continue;
                for (int n = 0; n < gc.getNumGeometries(); ++n) {
                    Geometry g = gc.getGeometryN(n);
                    if (!g.getEnvelopeInternal().intersects(env)) continue;
                    if (map == null) {
                        g.setUserData(dfr.readField(pos));
                    } else {
                        Object f = dfr.readField(pos);
                        if (map.containsKey(f + "")) {
                            g.setUserData((Object)map.get(f + ""));
                        } else {
                            g.setUserData(f);
                        }
                    }
                    spatialIndex.insert(g.getEnvelopeInternal(), (Object)g);
                }
            }
            sfr.close();
            dfr.close();
            spatialIndex.build();
            return spatialIndex;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private Class<?> getAttributeType(ShpFiles sf, String attribute) {
        try {
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (!dfh.getFieldName(f).equalsIgnoreCase(attribute)) continue;
                switch (dfh.getFieldType(f)) {
                    case 'C': {
                        return String.class;
                    }
                    case 'F': {
                        return Double.class;
                    }
                    case 'L': {
                        return Boolean.class;
                    }
                    case 'D': {
                        return Date.class;
                    }
                    case 'N': {
                        if (dfh.getFieldDecimalCount(f) > 0) {
                            return Double.class;
                        }
                        if (dfh.getFieldLength(f) > 10) {
                            return Long.class;
                        }
                        return Integer.class;
                    }
                }
                throw new IllegalArgumentException();
            }
            dfr.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }
}

