/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.FilteredRectangularWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.MultipleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.SimpleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.cluster.Cluster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClusteredWindowMatrixAnalysis
extends WindowMatrixAnalysis {
    private Set<Cluster> clusters;
    private Map<Integer, WindowMatrixProcess> processes;

    public ClusteredWindowMatrixAnalysis(Matrix m, Window w, WindowMatrixProcessType pType, Set<Cluster> clusters) {
        super(m, w, pType);
        this.clusters = clusters;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doRun() {
        this.processes = new HashMap<Integer, WindowMatrixProcess>();
        for (Cluster c : this.clusters) {
            Window window = null;
            for (Window w : ((MultipleWindow)this.window()).windows()) {
                if (((FilteredRectangularWindow)((SimpleWindow)w).shape()).getValue() != c.getValue()) continue;
                window = w;
            }
            window.locate(c.getCorner());
            this.processes.put(c.getValue(), this.processType().create(window, c.getCorner()));
        }
        for (int yt = 0; yt < this.matrix().numYTiles(); ++yt) {
            for (int xt = 0; xt < this.matrix().numXTiles(); ++xt) {
                this.distributeValues(xt, yt);
            }
        }
    }

    @Override
    protected void doClose() {
    }

    private void distributeValues(int xt, int yt) {
        int total = this.matrix().width() * this.matrix().height();
        for (int y = yt * this.matrix().tileHeight(); y < (yt + 1) * this.matrix().tileHeight() && y < this.matrix().height(); ++y) {
            System.out.println(y);
            for (int x = xt * this.matrix().tileWidth(); x < (xt + 1) * this.matrix().tileWidth() && x < this.matrix().width(); ++x) {
                double v = this.matrix().get(x, y);
                this.processType().setValue(x, y, v, null);
                for (WindowMatrixProcess wmp : this.processes.values()) {
                    wmp.add(x, y, v);
                }
                this.updateProgression(total);
            }
        }
    }

    @Override
    public void notify(Process p, ProcessState s) {
        if (p instanceof WindowMatrixProcess && p.processType().equals(this.processType())) {
            switch (s) {
                case READY: {
                    this.notifyProcessReady((WindowMatrixProcess)p);
                    break;
                }
                case DONE: {
                    this.notifyProcessDone((WindowMatrixProcess)p);
                }
            }
        }
    }

    private void notifyProcessReady(WindowMatrixProcess p) {
        p.calculateMetrics();
    }

    private void notifyProcessDone(WindowMatrixProcess p) {
        p.delete();
    }
}

