/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.VolatileWindowAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class NaiveSelectedWindowMatrixAnalysis
extends WindowMatrixAnalysis
implements VolatileWindowAnalysis {
    private Set<Pixel> pixels;
    private Set<WindowMatrixProcess> processes;
    private Set<WindowMatrixProcess> dones;
    private boolean update;
    private int xp;
    private int yp;
    private String path;
    private boolean exportFilters;

    public NaiveSelectedWindowMatrixAnalysis(Matrix m, Window w, WindowMatrixProcessType pType, double minRate, Set<Pixel> pixels, String path, boolean exportFilters) {
        super(m, w, pType);
        Metric.setMinRate(minRate);
        this.pixels = pixels;
        this.path = path;
        this.exportFilters = exportFilters;
    }

    @Override
    public Pixel next(Pixel pixel) {
        Pixel p = PixelManager.get(pixel.x() + 1, pixel.y());
        if (this.matrix().contains(p)) {
            return p;
        }
        p = PixelManager.get(0, pixel.y() + 1);
        if (this.matrix().contains(p)) {
            return p;
        }
        return null;
    }

    @Override
    public void doInit() {
        this.update = false;
        if (this.path != null) {
            new File(this.path + "filters/").mkdirs();
        }
    }

    @Override
    protected void doRun() {
        this.dones = new HashSet<WindowMatrixProcess>();
        this.processes = new TreeSet<WindowMatrixProcess>();
        for (int yt = 0; yt < this.matrix().numYTiles(); ++yt) {
            if (yt == 0) {
                this.yp = 0;
            }
            int ypt = ++this.yp;
            for (int xt = 0; xt < this.matrix().numXTiles(); ++xt) {
                this.xp = xt == 0 ? 0 : ++this.xp;
                this.yp = ypt;
                this.createProcesses(xt, yt);
            }
        }
    }

    @Override
    protected void doClose() {
    }

    private void createProcesses(int xt, int yt) {
        boolean yi = false;
        boolean xi = false;
        int x = this.xp;
        while (this.yp < (yt + 1) * this.matrix().tileHeight() + this.window().height() / 2 + 1 && this.yp < this.matrix().height()) {
            yi = true;
            this.xp = x;
            while (this.xp < (xt + 1) * this.matrix().tileWidth() + this.window().width() / 2 + 1 && this.xp < this.matrix().width()) {
                xi = true;
                Pixel p = PixelManager.get(this.xp, this.yp);
                if (this.pixels.contains(p)) {
                    WindowMatrixProcess wp = this.processType().create(this.window(), p, true);
                    this.processes.add(wp);
                    this.distributeValues(wp, xt, yt);
                }
                ++this.xp;
            }
            ++this.yp;
        }
        if (yi) {
            --this.yp;
        }
        if (xi) {
            --this.xp;
        }
    }

    private void distributeValues(WindowMatrixProcess wp, int xt, int yt) {
        int total = this.pixels.size();
        for (int y = Math.max(0, wp.y() - (wp.height() - 1) / 2); y < Math.min(this.matrix().height(), 1 + wp.y() + (wp.height() - 1) / 2); ++y) {
            for (int x = Math.max(0, wp.x() - (wp.width() - 1) / 2); x < Math.min(this.matrix().width(), 1 + wp.x() + (wp.width() - 1) / 2); ++x) {
                double v = this.matrix().get(x, y);
                this.processType().setValue(x, y, v, null);
                wp.add(x, y, v);
            }
        }
        this.update();
        this.updateProgression(total);
    }

    private void update() {
        if (this.update) {
            this.update = false;
            if (this.dones.size() > 0) {
                for (WindowMatrixProcess wp : this.dones) {
                    this.processes.remove(wp);
                }
                this.dones.clear();
            }
        }
    }

    @Override
    public void notify(Process p, ProcessState state) {
        if (p instanceof WindowMatrixProcess && p.processType().equals(this.processType())) {
            switch (state) {
                case INIT: {
                    this.notifyProcessInit((WindowMatrixProcess)p);
                    break;
                }
                case READY: {
                    this.notifyProcessReady((WindowMatrixProcess)p);
                    break;
                }
                case DONE: {
                    this.notifyProcessDone((WindowMatrixProcess)p);
                }
            }
        }
    }

    private void notifyProcessInit(WindowMatrixProcess wp) {
        this.update = true;
    }

    private void notifyProcessReady(WindowMatrixProcess p) {
        p.calculateMetrics();
        if (this.path != null) {
            Pixel pixel = null;
            for (Pixel pix : this.pixels) {
                if (pix.x() != p.x() || pix.y() != p.y()) continue;
                pixel = pix;
                break;
            }
            if (this.exportFilters) {
                if (pixel != null) {
                    p.window().export(pixel, this.matrix(), this.path + "filters/");
                } else {
                    p.window().export(p.pixel(), this.matrix(), this.path + "filters/");
                }
            }
        }
    }

    private void notifyProcessDone(WindowMatrixProcess wp) {
        this.dones.add(wp);
        wp.delete();
        wp = null;
        this.update = true;
    }
}

