/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.VolatileWindowAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class SlidingWindowMatrixAnalysis
extends WindowMatrixAnalysis
implements VolatileWindowAnalysis {
    private final int delta;
    private int xInit = 0;
    private int yInit = 0;
    private WindowMatrixProcess[] processes;
    private LinkedList<WindowMatrixProcess> finishProcesses;
    private Set<Integer> filters;
    private Set<Integer> unfilters;
    private Matrix matrixFilter;
    private Matrix matrixUnFilter;

    public SlidingWindowMatrixAnalysis(Matrix m, Window w, WindowMatrixProcessType pType, int delta, int xOrigin, int yOrigin, double minRate, Set<Integer> filters, Set<Integer> unfilters, Matrix matrixFilter, Matrix matrixUnFilter) {
        super(m, w, pType);
        this.delta = delta;
        this.xInit = xOrigin;
        this.yInit = yOrigin;
        Metric.setMinRate(minRate);
        this.filters = new HashSet<Integer>();
        this.filters.addAll(filters);
        this.unfilters = new HashSet<Integer>();
        this.unfilters.addAll(unfilters);
        this.matrixFilter = matrixFilter;
        this.matrixUnFilter = matrixUnFilter;
    }

    @Override
    public int delta() {
        return this.delta;
    }

    @Override
    public Pixel next(Pixel pixel) {
        pixel.setX(pixel.x() + this.delta);
        if (this.matrix().contains(pixel)) {
            return pixel;
        }
        pixel.setX(0);
        pixel.setY(pixel.y() + this.delta);
        if (this.matrix().contains(pixel)) {
            return pixel;
        }
        return null;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected void doRun() {
        this.processes = new WindowMatrixProcess[this.matrix().width()];
        this.createProcesses();
        for (int yt = 0; yt < this.matrix().numYTiles(); ++yt) {
            for (int xt = 0; xt < this.matrix().numXTiles(); ++xt) {
                this.distributeValues(xt, yt);
            }
        }
        if (this.finishProcesses != null) {
            while (this.finishProcesses.size() > 0) {
                WindowMatrixProcess wmp = this.finishProcesses.removeFirst();
                this.calculate(wmp);
            }
        }
        this.window().close();
    }

    private void createProcesses() {
        for (int x = this.xInit; x < this.processes.length; x += this.delta) {
            this.processes[x] = this.processType().create(this.window(), new Pixel(x, this.yInit));
        }
    }

    private void distributeValues(int xt, int yt) {
        int total = this.matrix().width() * this.matrix().height();
        for (int y = yt * this.matrix().tileHeight(); y < (yt + 1) * this.matrix().tileHeight() && y < this.matrix().height(); ++y) {
            for (int x = xt * this.matrix().tileWidth(); x < (xt + 1) * this.matrix().tileWidth() && x < this.matrix().width(); ++x) {
                double v = this.matrix().get(x, y);
                this.processType().setValue(x, y, v, null);
                for (int ix = Math.max(0, x - this.window().width() / 2); ix <= Math.min(this.matrix().width() - 1, x + this.window().width() / 2); ++ix) {
                    if (this.processes[ix] == null) continue;
                    this.processes[ix].add(x, y, v);
                }
                this.updateProgression(total);
            }
        }
    }

    @Override
    public void notify(Process p, ProcessState s) {
        if (p instanceof WindowMatrixProcess && p.processType().equals(this.processType())) {
            switch (s) {
                case INIT: {
                    this.notifyProcessInit((WindowMatrixProcess)p);
                    break;
                }
                case READY: {
                    this.notifyProcessReady((WindowMatrixProcess)p);
                    break;
                }
                case DONE: {
                    this.notifyProcessDone((WindowMatrixProcess)p);
                    break;
                }
                case FINISH: {
                    this.notifyProcessFinish((WindowMatrixProcess)p);
                }
            }
        }
    }

    private void notifyProcessInit(WindowMatrixProcess wp) {
    }

    private void notifyProcessReady(WindowMatrixProcess wp) {
        this.calculate(wp);
    }

    private void notifyProcessDone(WindowMatrixProcess wp) {
        wp.down(this.delta);
    }

    private void notifyProcessFinish(WindowMatrixProcess wp) {
        if (this.finishProcesses == null) {
            this.finishProcesses = new LinkedList();
        }
        this.finishProcesses.add(wp);
    }

    private void calculate(WindowMatrixProcess wp) {
        double v = this.matrix().get(wp.x(), wp.y());
        boolean filter = true;
        if (this.unfilters.contains((int)v) || this.filters.size() > 0 && !this.filters.contains((int)v) || this.matrixFilter != null && (this.matrixFilter.get(wp.x(), wp.y()) == (double)Raster.getNoDataValue() || this.matrixFilter.get(wp.x(), wp.y()) == 0.0) || this.matrixUnFilter != null && this.matrixUnFilter.get(wp.x(), wp.y()) != 0.0) {
            filter = false;
        }
        if (filter) {
            wp.calculateMetrics();
        } else {
            wp.unCalculateMetrics();
        }
    }
}

