/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.shape;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShape;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.distance.DistanceFunction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelWithID;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.CoordinateManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class CircleWindow2
extends WindowShape {
    private int diameter;
    private double rayon;
    private final int[] filter;
    private int theoriticalSize;
    private List<Pixel> addDownList;
    private List<Pixel> removeDownList;
    private List<Pixel> addVerticalDownList;
    private List<Pixel> removeVerticalDownList;
    private List<Pixel> addHorizontalDownList;
    private List<Pixel> removeHorizontalDownList;
    private double[][] distance;
    private double[][] weighted;
    private double[][] weightedH;
    private double[][] weightedV;

    public CircleWindow2(double rayon) {
        this.rayon = rayon;
        this.diameter = new Double(2.0 * rayon / Raster.getCellSize()).intValue();
        if (this.diameter % 2 == 0) {
            ++this.diameter;
        }
        this.filter = new int[this.diameter * this.diameter];
        this.init();
    }

    public CircleWindow2(int d) {
        this.diameter = d;
        this.filter = new int[this.diameter * this.diameter];
        this.init();
    }

    public CircleWindow2(int d, DistanceFunction function) {
        super(function);
        this.diameter = d;
        this.filter = new int[this.diameter * this.diameter];
        this.init();
    }

    @Override
    public double[][] weighted() {
        if (this.weighted == null) {
            double rayon = new Double(this.diameter) / 2.0 - 0.5;
            this.initWeighted(rayon);
        }
        return this.weighted;
    }

    @Override
    public double[][] weightedH() {
        if (this.weightedH == null) {
            if (this.weighted == null) {
                double rayon = new Double(this.diameter) / 2.0 - 0.5;
                this.initWeighted(rayon);
            }
            this.initWeightedCouple();
        }
        return this.weightedH;
    }

    @Override
    public double[][] weightedV() {
        if (this.weightedV == null) {
            if (this.weighted == null) {
                double rayon = new Double(this.diameter) / 2.0 - 0.5;
                this.initWeighted(rayon);
            }
            this.initWeightedCouple();
        }
        return this.weightedV;
    }

    protected void initWeighted(double rayon1) {
        double rayon2 = new Double(this.diameter) / 2.0;
        this.distance = new double[this.diameter][this.diameter];
        WKTReader wkt = new WKTReader();
        try {
            Point center = (Point)wkt.read("POINT (" + (rayon1 + 0.5) + " " + (rayon1 + 0.5) + ")");
            int j = 0;
            int i = 0;
            for (double y = 0.5; y < (double)this.diameter; y += 1.0) {
                for (double x = 0.5; x < (double)this.diameter; x += 1.0) {
                    Point p = (Point)wkt.read("POINT (" + x + " " + y + ")");
                    double d = center.distance((Geometry)p);
                    this.distance[j][i] = d > rayon1 ? (double)Raster.getNoDataValue() : d * Raster.getCellSize();
                    ++i;
                }
                ++j;
                i = 0;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.weighted = new double[this.diameter][this.diameter];
        for (int j = 0; j < this.diameter; ++j) {
            for (int i = 0; i < this.diameter; ++i) {
                this.weighted[j][i] = this.getDistanceFunction().interprete(this.distance[j][i]);
            }
        }
    }

    protected void initWeightedCouple() {
        int i;
        int j;
        this.weightedH = new double[this.diameter][this.diameter - 1];
        for (j = 0; j < this.diameter; ++j) {
            for (i = 0; i < this.diameter - 1; ++i) {
                this.weightedH[j][i] = this.getDistanceFunction().interprete((this.distance[j][i] + this.distance[j][i + 1]) / 2.0);
            }
        }
        this.weightedV = new double[this.diameter - 1][this.diameter];
        for (j = 0; j < this.diameter - 1; ++j) {
            for (i = 0; i < this.diameter; ++i) {
                this.weightedV[j][i] = this.getDistanceFunction().interprete((this.distance[j][i] + this.distance[j + 1][i]) / 2.0);
            }
        }
    }

    @Override
    public int theoreticalSize() {
        return this.theoriticalSize;
    }

    protected void init() {
        double rayon1 = new Double(this.diameter) / 2.0 - 0.5;
        double rayon = this.rayon / Raster.getCellSize();
        WKTReader wkt = new WKTReader();
        try {
            Point center = (Point)wkt.read("POINT (" + (rayon1 + 0.5) + " " + (rayon1 + 0.5) + ")");
            int index = 0;
            this.theoriticalSize = 0;
            for (double y = 0.5; y < (double)this.diameter; y += 1.0) {
                for (double x = 0.5; x < (double)this.diameter; x += 1.0) {
                    Point p = (Point)wkt.read("POINT (" + x + " " + y + ")");
                    if (center.distance((Geometry)p) > rayon) {
                        this.filter[index++] = 0;
                        continue;
                    }
                    this.filter[index++] = 1;
                    ++this.theoriticalSize;
                }
            }
            index = 0;
            for (int x = 0; x < this.diameter; ++x) {
                if (x == 0) {
                    if (this.filter[index] != 0) {
                        this.filter[index] = 4;
                    }
                } else if (this.filter[index] != 0) {
                    this.filter[index] = this.filter[index - 1] != 0 ? 2 : 4;
                }
                ++index;
            }
            for (int y = 1; y < this.diameter; ++y) {
                for (int x = 0; x < this.diameter; ++x) {
                    if (x == 0) {
                        if (this.filter[index] != 0) {
                            this.filter[index] = this.filter[index - this.diameter] != 0 ? 3 : 4;
                        }
                    } else if (this.filter[index] != 0) {
                        if (this.filter[index - 1] == 0) {
                            this.filter[index] = this.filter[index - this.diameter] == 0 ? 4 : 3;
                        } else if (this.filter[index - this.diameter] == 0) {
                            this.filter[index] = 2;
                        }
                    }
                    ++index;
                }
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int width() {
        return this.diameter;
    }

    @Override
    public int height() {
        return this.diameter;
    }

    @Override
    public int filter(int wx, int wy) {
        return this.filter[wy * this.width() + wx];
    }

    private Pixel pixelByIndex(int index) {
        return new Pixel(index % this.width(), index / this.width());
    }

    private void initLists() {
        if (this.addDownList == null) {
            this.addDownList = new LinkedList<Pixel>();
            this.removeDownList = new LinkedList<Pixel>();
            this.addHorizontalDownList = new LinkedList<Pixel>();
            this.removeHorizontalDownList = new LinkedList<Pixel>();
            this.addVerticalDownList = new LinkedList<Pixel>();
            this.removeVerticalDownList = new LinkedList<Pixel>();
            for (int i = 0; i < this.filter.length; ++i) {
                if (this.filter[i] == 2 || this.filter[i] == 4) {
                    this.removeDownList.add(this.pixelByIndex(i));
                }
                if (i >= this.width() && this.filter[i] == 0 && this.filter[i - this.width()] != 0) {
                    this.addDownList.add(this.pixelByIndex(i));
                }
                if (i < this.width() && this.filter[i] == 2) {
                    this.removeHorizontalDownList.add(this.pixelByIndex(i));
                }
                if (!(i < this.width() || i % this.width() == 0 || this.filter[i] != 1 && this.filter[i] != 2 || this.filter[i - this.width()] != 0 && this.filter[i - this.width()] != 3 && this.filter[i - this.width()] != 4)) {
                    this.removeHorizontalDownList.add(this.pixelByIndex(i));
                }
                if (!(i < this.width() || i % this.width() == 0 || this.filter[i] != 0 && this.filter[i] != 3 && this.filter[i] != 4 || this.filter[i - this.width()] != 1 && this.filter[i - this.width()] != 2)) {
                    this.addHorizontalDownList.add(this.pixelByIndex(i));
                }
                if (!(i < this.width() || this.filter[i] != 1 && this.filter[i] != 3 || this.filter[i - this.width()] != 0 && this.filter[i - this.width()] != 2 && this.filter[i - this.width()] != 4)) {
                    this.removeVerticalDownList.add(this.pixelByIndex(i));
                }
                if (i < this.width() || this.filter[i] != 0 && this.filter[i] != 2 && this.filter[i] != 4 || this.filter[i - this.width()] != 1 && this.filter[i - this.width()] != 3) continue;
                this.addVerticalDownList.add(this.pixelByIndex(i));
            }
        }
    }

    @Override
    public List<Pixel> removeDownList() {
        this.initLists();
        return this.removeDownList;
    }

    @Override
    public List<Pixel> addDownList() {
        this.initLists();
        return this.addDownList;
    }

    @Override
    public List<Pixel> removeHorizontalDownList() {
        this.initLists();
        return this.removeHorizontalDownList;
    }

    @Override
    public List<Pixel> addHorizontalDownList() {
        this.initLists();
        return this.addHorizontalDownList;
    }

    @Override
    public List<Pixel> removeVerticalDownList() {
        this.initLists();
        return this.removeVerticalDownList;
    }

    @Override
    public List<Pixel> addVerticalDownList() {
        this.initLists();
        return this.addVerticalDownList;
    }

    @Override
    public void display() {
        int index = 0;
        System.out.println();
        for (int f : this.filter) {
            System.out.print(f + " ");
            if (++index % this.diameter != 0) continue;
            System.out.println();
        }
        if (this.weighted != null) {
            int i;
            int j;
            System.out.println();
            for (j = 0; j < this.diameter; ++j) {
                for (i = 0; i < this.diameter; ++i) {
                    System.out.print(this.distance[j][i] + " ");
                }
                System.out.println();
            }
            System.out.println();
            for (j = 0; j < this.diameter; ++j) {
                for (i = 0; i < this.diameter; ++i) {
                    System.out.print(this.weighted[j][i] + " ");
                }
                System.out.println();
            }
        }
    }

    @Override
    public void export(Pixel p, Matrix m, String path) {
        try {
            String name = new File(m.getFile()).getName().replace(".asc", "");
            String file = "";
            file = p instanceof PixelWithID ? path + name + "_circle_" + this.diameter + "_" + ((PixelWithID)p).getId() + ".asc" : path + name + "_circle_" + this.diameter + "_" + CoordinateManager.getProjectedX(m, p.x()) + "-" + CoordinateManager.getProjectedY(m, p.y()) + ".asc";
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            double delta = (double)this.diameter / 2.0;
            double X = CoordinateManager.getProjectedX(m, p.x());
            double nX = X - delta * Raster.getCellSize();
            double Y = CoordinateManager.getProjectedY(m, p.y());
            double nY = Y - delta * Raster.getCellSize();
            out.write("ncols ");
            out.write(this.diameter + "");
            out.newLine();
            out.write("nrows ");
            out.write(this.diameter + "");
            out.newLine();
            out.write("xllcorner ");
            out.write(nX + "");
            out.newLine();
            out.write("yllcorner ");
            out.write(nY + "");
            out.newLine();
            out.write("cellsize ");
            out.write(Raster.getCellSize() + "");
            out.newLine();
            out.write("NODATA_value  ");
            out.write(Raster.getNoDataValue() + "");
            out.newLine();
            int index = 0;
            for (int j = p.y() - this.diameter / 2; j < p.y() + 1 + this.diameter / 2; ++j) {
                for (int i = p.x() - this.diameter / 2; i < p.x() + 1 + this.diameter / 2; ++i) {
                    if (this.filter[index++] == 0) {
                        out.write("-1 ");
                        continue;
                    }
                    out.write(m.get(i, j) + " ");
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void infos() {
    }
}

