/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.shape;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.LocateFunctionalWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShape;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.distance.DistanceFunction;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessObserver;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.ArrayMatrixFactory;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public abstract class FunctionalWindow
extends WindowShape
implements ProcessObserver {
    protected double dMax;
    protected Matrix matrix;
    private Map<Pixel, LocateFunctionalWindow> locations;
    private LocateFunctionalWindow location;
    private Pixel locate;
    private TreeSet<Pixel> waits;
    private Matrix rcm;
    private boolean isInit;
    private List<Pixel> addDownList;
    private List<Pixel> removeDownList;
    private List<Pixel> addVerticalDownList;
    private List<Pixel> removeVerticalDownList;
    private List<Pixel> addHorizontalDownList;
    private List<Pixel> removeHorizontalDownList;
    private int displacement;
    private Pixel[][] pixels;
    private double fmin;
    private int theoreticalSize;

    public FunctionalWindow(Matrix m, double d, double min, DistanceFunction function) {
        this(m, d, -1, min, function);
    }

    public FunctionalWindow(Matrix m, double d, double min) {
        this(m, d, -1, min);
    }

    public FunctionalWindow(Matrix m, double d, int displacement, double min) {
        this(m, d, displacement, min, null);
    }

    public FunctionalWindow(Matrix m, double d, int displacement, double min, DistanceFunction function) {
        super(function);
        this.matrix = m;
        this.dMax = d;
        this.fmin = min;
        this.displacement = displacement;
        this.locations = new TreeMap<Pixel, LocateFunctionalWindow>();
        this.rcm = ArrayMatrixFactory.get().create(this.diameter(), this.diameter(), m.cellsize(), 0.0, 0.0, 0.0, 0.0, Raster.getNoDataValue());
        this.waits = new TreeSet<Pixel>(new Comparator<Pixel>(){

            @Override
            public int compare(Pixel p1, Pixel p2) {
                if (FunctionalWindow.this.rcm.get(p1) > FunctionalWindow.this.rcm.get(p2)) {
                    return 1;
                }
                return -1;
            }
        });
        this.isInit = false;
        this.addDownList = new LinkedList<Pixel>();
        this.removeDownList = new LinkedList<Pixel>();
        this.addHorizontalDownList = new LinkedList<Pixel>();
        this.removeHorizontalDownList = new LinkedList<Pixel>();
        this.addVerticalDownList = new LinkedList<Pixel>();
        this.removeVerticalDownList = new LinkedList<Pixel>();
        this.pixels = new Pixel[this.diameter()][this.diameter()];
        for (int y = 0; y < this.diameter(); ++y) {
            for (int x = 0; x < this.diameter(); ++x) {
                this.pixels[y][x] = new Pixel(x, y);
            }
        }
    }

    protected void initTheoriticalSize() {
        int width = this.width();
        double rayon = new Double(width) / 2.0 - 0.5;
        WKTReader wkt = new WKTReader();
        try {
            Point center = (Point)wkt.read("POINT (" + (rayon + 0.5) + " " + (rayon + 0.5) + ")");
            this.theoreticalSize = 0;
            for (double y = 0.5; y < (double)width; y += 1.0) {
                for (double x = 0.5; x < (double)width; x += 1.0) {
                    Point p = (Point)wkt.read("POINT (" + x + " " + y + ")");
                    if (!(center.distance((Geometry)p) <= rayon)) continue;
                    ++this.theoreticalSize;
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public double[][] weighted() {
        return this.locations.get(this.locate).weighted();
    }

    @Override
    public double[][] weightedH() {
        return this.locations.get(this.locate).weightedH();
    }

    @Override
    public double[][] weightedV() {
        return this.locations.get(this.locate).weightedV();
    }

    private Pixel pixel(int x, int y) {
        return this.pixels[y][x];
    }

    public Matrix matrix() {
        return this.matrix;
    }

    @Override
    public int theoreticalSize() {
        return this.theoreticalSize;
    }

    @Override
    public int diameter() {
        this.fmin = 1.0;
        int v = new Double(2.0 * this.dMax / this.matrix.cellsize() / this.fmin).intValue();
        if (v % 2 == 0) {
            return new Double(2.0 * this.dMax / this.matrix.cellsize() / this.fmin).intValue() + 1;
        }
        return new Double(2.0 * this.dMax / this.matrix.cellsize() / this.fmin).intValue();
    }

    @Override
    public int filter(int wx, int wy) {
        return this.location.filter(wx, wy);
    }

    @Override
    public void locate(int x, int y) {
        this.locate = new Pixel(x, y);
        if (!this.locations.containsKey(this.locate)) {
            this.location = this.displacement == -1 || y % this.displacement == 0 ? this.diffusion(this.window.toWindow(this.locate)) : this.locations.get(new Pixel(x, y - y % this.displacement));
            this.locations.put(this.locate, this.location);
        } else {
            this.location = this.locations.get(this.locate);
        }
        if (this.displacement != -1 && this.locations.containsKey(new Pixel(x, y - this.displacement))) {
            this.locations.remove(new Pixel(x, y - this.displacement));
        }
    }

    @Override
    public void reinit() {
        this.isInit = false;
    }

    private void initLists() {
        if (!this.isInit) {
            int i;
            this.isInit = true;
            this.addDownList.clear();
            this.removeDownList.clear();
            this.addHorizontalDownList.clear();
            this.removeHorizontalDownList.clear();
            this.addVerticalDownList.clear();
            this.removeVerticalDownList.clear();
            int[] f1 = this.location.filters();
            this.window.locate(this.locate.x(), this.locate.y() + 1);
            int[] f2 = this.location.filters();
            for (i = 0; i < this.width(); ++i) {
                if (f1[i] != 0) {
                    this.removeDownList.add(this.pixelByIndex(i));
                }
                if (f1[i] != 2) continue;
                this.removeHorizontalDownList.add(this.pixelByIndex(i));
            }
            for (i = this.width(); i < f1.length; ++i) {
                if (f1[i] != 0 && f2[i - this.width()] == 0) {
                    this.removeDownList.add(this.pixelByIndex(i));
                }
                if (f1[i] == 0 && f2[i - this.width()] != 0) {
                    this.addDownList.add(this.pixelByIndex(i));
                }
                if (!(i % this.width() == 0 || f1[i] != 1 && f1[i] != 2 || f2[i - this.width()] != 0 && f2[i - this.width()] != 3 && f2[i - this.width()] != 4)) {
                    this.removeHorizontalDownList.add(this.pixelByIndex(i));
                }
                if (!(i % this.width() == 0 || f1[i] != 0 && f1[i] != 3 && f1[i] != 4 || f2[i - this.width()] != 1 && f2[i - this.width()] != 2)) {
                    this.addHorizontalDownList.add(this.pixelByIndex(i));
                }
                if (!(f1[i] != 1 && f1[i] != 3 || f2[i - this.width()] != 0 && f2[i - this.width()] != 2 && f2[i - this.width()] != 4)) {
                    this.removeVerticalDownList.add(this.pixelByIndex(i));
                }
                if (f1[i] != 0 && f1[i] != 2 && f1[i] != 4 || f2[i - this.width()] != 1 && f2[i - this.width()] != 3) continue;
                this.addVerticalDownList.add(this.pixelByIndex(i));
            }
            this.window.locate(this.locate.x(), this.locate.y() - 1);
        }
    }

    private Pixel pixelByIndex(int index) {
        return new Pixel(index % this.width(), index / this.width());
    }

    @Override
    public List<Pixel> removeDownList() {
        this.initLists();
        return this.removeDownList;
    }

    @Override
    public List<Pixel> addDownList() {
        this.initLists();
        return this.addDownList;
    }

    @Override
    public List<Pixel> removeHorizontalDownList() {
        this.initLists();
        return this.removeHorizontalDownList;
    }

    @Override
    public List<Pixel> removeVerticalDownList() {
        this.initLists();
        return this.removeVerticalDownList;
    }

    @Override
    public List<Pixel> addHorizontalDownList() {
        this.initLists();
        return this.addHorizontalDownList;
    }

    @Override
    public List<Pixel> addVerticalDownList() {
        this.initLists();
        return this.addVerticalDownList;
    }

    private LocateFunctionalWindow diffusion(Pixel p) {
        int x;
        int y;
        this.rcm.init(2.147483647E9);
        this.rcm.put(p, 0.0);
        this.waits.clear();
        this.waits.add(p);
        while (!this.waits.isEmpty()) {
            this.diffuse();
        }
        int[] filter = new int[this.size()];
        int index = 0;
        for (y = 0; y < this.height(); ++y) {
            for (x = 0; x < this.width(); ++x) {
                Pixel px = this.pixel(x, y);
                filter[index] = this.rcm.get(px) != 2.147483647E9 ? 1 : 0;
                ++index;
            }
        }
        index = 0;
        for (int x2 = 0; x2 < this.width(); ++x2) {
            if (x2 == 0) {
                if (filter[index] != 0) {
                    filter[index] = 4;
                }
            } else if (filter[index] != 0) {
                filter[index] = filter[index - 1] != 0 ? 2 : 4;
            }
            ++index;
        }
        for (y = 1; y < this.height(); ++y) {
            for (x = 0; x < this.width(); ++x) {
                if (x == 0) {
                    if (filter[index] != 0) {
                        filter[index] = filter[index - this.width()] != 0 ? 3 : 4;
                    }
                } else if (filter[index] != 0) {
                    if (filter[index - 1] == 0) {
                        filter[index] = filter[index - this.width()] == 0 ? 4 : 3;
                    } else if (filter[index - this.width()] == 0) {
                        filter[index] = 2;
                    }
                }
                ++index;
            }
        }
        return new LocateFunctionalWindow(filter, this.getDistanceFunction());
    }

    protected abstract double friction(Matrix var1, Pixel var2);

    private void diffuseRook(Pixel pc, Pixel op, double v, double f) {
        double ov;
        double of;
        if (this.rcm.get(op) == 2.147483647E9 && (of = this.friction(this.matrix, op)) != (double)Raster.getNoDataValue() && (ov = v + (this.matrix.cellsize() / 2.0 * f + this.matrix.cellsize() / 2.0 * of)) <= this.dMax) {
            this.rcm.put(op, ov);
            this.waits.add(op);
        }
    }

    private void diffuseQueen(Pixel pc, Pixel op, double v, double f) {
        double ov;
        double of;
        if (this.rcm.get(op) == 2.147483647E9 && (of = this.friction(this.matrix, op)) != (double)Raster.getNoDataValue() && (ov = v + (Math.sqrt(2.0) * this.matrix.cellsize() / 2.0 * f + Math.sqrt(2.0) * this.matrix.cellsize() / 2.0 * of)) <= this.dMax) {
            this.rcm.put(op, ov);
            this.waits.add(op);
        }
    }

    private void diffuse() {
        Pixel p = this.waits.pollFirst();
        double f = this.friction(this.matrix, p);
        if (f != (double)Raster.getNoDataValue()) {
            double v = this.rcm.get(p);
            if (p.x() >= 0 && p.x() < this.pixels[0].length && p.y() - 1 >= 0 && p.y() - 1 < this.pixels[0].length) {
                this.diffuseRook(p, this.pixel(p.x(), p.y() - 1), v, f);
            }
            if (p.x() + 1 >= 0 && p.x() + 1 < this.pixels[0].length && p.y() >= 0 && p.y() < this.pixels[0].length) {
                this.diffuseRook(p, this.pixel(p.x() + 1, p.y()), v, f);
            }
            if (p.x() >= 0 && p.x() < this.pixels[0].length && p.y() + 1 >= 0 && p.y() + 1 < this.pixels[0].length) {
                this.diffuseRook(p, this.pixel(p.x(), p.y() + 1), v, f);
            }
            if (p.x() - 1 >= 0 && p.x() - 1 < this.pixels[0].length && p.y() >= 0 && p.y() < this.pixels[0].length) {
                this.diffuseRook(p, this.pixel(p.x() - 1, p.y()), v, f);
            }
            if (p.x() + 1 >= 0 && p.x() + 1 < this.pixels[0].length && p.y() - 1 >= 0 && p.y() - 1 < this.pixels[0].length) {
                this.diffuseQueen(p, this.pixel(p.x() + 1, p.y() - 1), v, f);
            }
            if (p.x() + 1 >= 0 && p.x() + 1 < this.pixels[0].length && p.y() + 1 >= 0 && p.y() + 1 < this.pixels[0].length) {
                this.diffuseQueen(p, this.pixel(p.x() + 1, p.y() + 1), v, f);
            }
            if (p.x() - 1 >= 0 && p.x() - 1 < this.pixels[0].length && p.y() + 1 >= 0 && p.y() + 1 < this.pixels[0].length) {
                this.diffuseQueen(p, this.pixel(p.x() - 1, p.y() + 1), v, f);
            }
            if (p.x() - 1 >= 0 && p.x() - 1 < this.pixels[0].length && p.y() - 1 >= 0 && p.y() - 1 < this.pixels[0].length) {
                this.diffuseQueen(p, this.pixel(p.x() - 1, p.y() - 1), v, f);
            }
        }
    }

    @Override
    public void notify(Process p, ProcessState s) {
        switch (s) {
            case DONE: {
                Map.Entry<Pixel, LocateFunctionalWindow> e;
                WindowMatrixProcess wp = (WindowMatrixProcess)p;
                Pixel pi = new Pixel(wp.x(), wp.y() - 1);
                Iterator<Map.Entry<Pixel, LocateFunctionalWindow>> ite = this.locations.entrySet().iterator();
                while (ite.hasNext() && (e = ite.next()).getKey().y() < wp.y() - 1) {
                    ite.remove();
                }
                break;
            }
        }
    }

    @Override
    public int compareTo(ProcessObserver o) {
        return 1;
    }

    @Override
    public void display() {
        this.location.display();
    }

    @Override
    public void export(Pixel p, Matrix m, String path) {
        this.location.export(p, m, path);
    }

    @Override
    public void infos() {
        System.out.println(this.locations.size());
    }
}

