/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.shape;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShape;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.distance.DistanceFunction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelWithID;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.CoordinateManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class SquareWindow
extends WindowShape {
    private int size;
    private List<Pixel> addDownList;
    private List<Pixel> removeDownList;
    private List<Pixel> removeHorizontalDownList;
    private List<Pixel> removeVerticalDownList;
    private double[][] distance;
    private double[][] weigted;
    private double[][] weigtedH;
    private double[][] weigtedV;

    public SquareWindow(int s) {
        this.size = s;
    }

    public SquareWindow(int s, DistanceFunction function) {
        super(function);
        this.size = s;
    }

    @Override
    public int width() {
        return this.size;
    }

    @Override
    public int height() {
        return this.size;
    }

    private Pixel pixelByIndex(int index) {
        return new Pixel(index % this.size, index / this.size);
    }

    private void initLists() {
        if (this.addDownList == null) {
            int x;
            this.addDownList = new LinkedList<Pixel>();
            this.removeDownList = new LinkedList<Pixel>();
            this.removeHorizontalDownList = new LinkedList<Pixel>();
            this.removeVerticalDownList = new LinkedList<Pixel>();
            for (x = 0; x < this.size; ++x) {
                Pixel p = new Pixel(x, 0);
                this.removeDownList.add(p);
                if (x <= 0) continue;
                this.removeHorizontalDownList.add(p);
            }
            for (x = this.size; x < 2 * this.size; ++x) {
                this.removeVerticalDownList.add(this.pixelByIndex(x));
            }
        }
    }

    @Override
    public List<Pixel> removeDownList() {
        this.initLists();
        return this.removeDownList;
    }

    @Override
    public List<Pixel> addDownList() {
        this.initLists();
        return this.addDownList;
    }

    @Override
    public List<Pixel> removeHorizontalDownList() {
        this.initLists();
        return this.removeHorizontalDownList;
    }

    @Override
    public List<Pixel> removeVerticalDownList() {
        this.initLists();
        return this.removeVerticalDownList;
    }

    @Override
    public List<Pixel> addHorizontalDownList() {
        this.initLists();
        return this.addDownList;
    }

    @Override
    public List<Pixel> addVerticalDownList() {
        this.initLists();
        return this.addDownList;
    }

    @Override
    public void display() {
    }

    @Override
    public void export(Pixel p, Matrix m, String path) {
        try {
            String name = new File(m.getFile()).getName().replace(".asc", "");
            String file = "";
            file = p instanceof PixelWithID ? path + name + "_square_" + this.size + "_" + ((PixelWithID)p).getId() + ".asc" : path + name + "_square_" + this.size + "_" + CoordinateManager.getProjectedX(m, p.x()) + "-" + CoordinateManager.getProjectedY(m, p.y()) + ".asc";
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            double delta = (double)this.size / 2.0;
            double X = CoordinateManager.getProjectedX(m, p.x());
            double nX = X - delta * Raster.getCellSize();
            double Y = CoordinateManager.getProjectedY(m, p.y());
            double nY = Y - delta * Raster.getCellSize();
            out.write("ncols ");
            out.write(this.size + "");
            out.newLine();
            out.write("nrows ");
            out.write(this.size + "");
            out.newLine();
            out.write("xllcorner ");
            out.write(nX + "");
            out.newLine();
            out.write("yllcorner ");
            out.write(nY + "");
            out.newLine();
            out.write("cellsize ");
            out.write(Raster.getCellSize() + "");
            out.newLine();
            out.write("NODATA_value  ");
            out.write(Raster.getNoDataValue() + "");
            out.newLine();
            for (int j = p.y() - this.size / 2; j < p.y() + 1 + this.size / 2; ++j) {
                for (int i = p.x() - this.size / 2; i < p.x() + 1 + this.size / 2; ++i) {
                    out.write(m.get(i, j) + " ");
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void infos() {
    }
}

