/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.shape;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.distance.DistanceFunction;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.List;

public abstract class WindowShape {
    protected Window window;
    private DistanceFunction function;

    public WindowShape() {
    }

    public WindowShape(DistanceFunction function) {
        this.function = function;
    }

    public double[][] weighted() {
        throw new UnsupportedOperationException();
    }

    public double[][] weightedH() {
        throw new UnsupportedOperationException();
    }

    public double[][] weightedV() {
        throw new UnsupportedOperationException();
    }

    public DistanceFunction getDistanceFunction() {
        return this.function;
    }

    public abstract int width();

    public abstract int height();

    public void setWindow(Window w) {
        this.window = w;
    }

    public int diameter() {
        return this.width();
    }

    public void locate(int x, int y) {
    }

    public int filter(int wx, int wy) {
        if (wx > 0 && wx <= this.width()) {
            if (wy > 0 && wy <= this.height()) {
                return 1;
            }
            return 2;
        }
        if (wy > 0 && wy <= this.height()) {
            return 3;
        }
        return 4;
    }

    public int size() {
        return this.width() * this.height();
    }

    public int theoreticalSize() {
        return this.width() * this.height();
    }

    public int sizeTrunkUp(int u) {
        return this.width() * (this.height() - u);
    }

    public int sizeTrunkDown(int d) {
        return this.width() * (this.height() - d);
    }

    public int sizeTrunkLeft(int l) {
        return (this.width() - l) * this.height();
    }

    public int sizeTrunkRight(int r) {
        return (this.width() - r) * this.height();
    }

    public int sizeTrunkUpDown(int u, int d) {
        return this.width() * (this.height() - u - d);
    }

    public int sizeTrunkLeftRight(int l, int r) {
        return (this.width() - l - r) * this.height();
    }

    public int sizeTrunkUpLeft(int u, int l) {
        return (this.width() - l) * (this.height() - u);
    }

    public int sizeTrunkUpRight(int u, int r) {
        return (this.width() - r) * (this.height() - u);
    }

    public int sizeTrunkDownLeft(int d, int l) {
        return (this.width() - l) * (this.height() - d);
    }

    public int sizeTrunkDownRight(int d, int r) {
        return (this.width() - r) * (this.height() - d);
    }

    public int sizeTrunkUpDownLeft(int u, int d, int l) {
        return (this.width() - l) * (this.height() - u - d);
    }

    public int sizeTrunkUpDownRight(int u, int d, int r) {
        return (this.width() - r) * (this.height() - u - d);
    }

    public int sizeTrunkUpLeftRight(int u, int l, int r) {
        return (this.width() - l - r) * (this.height() - u);
    }

    public int sizeTrunkDownLeftRight(int d, int l, int r) {
        return (this.width() - l - r) * (this.height() - d);
    }

    public int sizeTrunkUpDownLeftRight(int u, int d, int l, int r) {
        return (this.width() - l - r) * (this.height() - u - d);
    }

    public abstract List<Pixel> removeDownList();

    public abstract List<Pixel> addDownList();

    public abstract List<Pixel> removeHorizontalDownList();

    public abstract List<Pixel> addHorizontalDownList();

    public abstract List<Pixel> removeVerticalDownList();

    public abstract List<Pixel> addVerticalDownList();

    public void reinit() {
    }

    public void close() {
    }

    public abstract void display();

    public abstract void export(Pixel var1, Matrix var2, String var3);

    public abstract void infos();
}

