/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.type;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShape;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.SimpleWindow;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.List;

public class CenteredWindow
extends SimpleWindow {
    private final int centerX = this.width() / 2;
    private final int centerY = this.height() / 2;

    public CenteredWindow(WindowShape shape) {
        super(shape);
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    @Override
    public Pixel getPixel(int wx, int wy) {
        return new Pixel(this.pixel().x() - this.width() / 2 + wx, this.pixel().y() - this.height() / 2 + wy);
    }

    @Override
    public Pixel getPixel(Pixel wp) {
        return this.getPixel(wp.x(), wp.y());
    }

    @Override
    public double get(Matrix m, int wx, int wy) {
        return m.get(this.pixel().x() - this.width() / 2 + wx, this.pixel().y() - this.height() / 2 + wy);
    }

    @Override
    public double get(Matrix m, Pixel wp) {
        return this.get(m, wp.x(), wp.y());
    }

    @Override
    public boolean accept(int x, int y) {
        return Math.abs(this.pixel().x() - x) <= this.width() / 2 && Math.abs(this.pixel().y() - y) <= this.height() / 2;
    }

    @Override
    public boolean accept(Pixel p) {
        return this.accept(p.x(), p.y());
    }

    @Override
    public Pixel toWindow(int x, int y) {
        return new Pixel(x + this.centerX - this.pixel().x(), y + this.centerY - this.pixel().y());
    }

    @Override
    public int toXWindow(int x) {
        return x + this.centerX - this.pixel().x();
    }

    @Override
    public int toYWindow(int y) {
        return y + this.centerY - this.pixel().y();
    }

    @Override
    public int outXWindow(int inX) {
        return inX + this.pixel().x() - this.centerX;
    }

    @Override
    public int outYWindow(int inY) {
        return inY + this.pixel().y() - this.centerY;
    }

    @Override
    public Pixel toWindow(Pixel p) {
        return this.toWindow(p.x(), p.y());
    }

    @Override
    public int size() {
        return this.shape().size();
    }

    @Override
    public int size(int width, int height) {
        int du = 0 - (this.pixel().y() - this.height() / 2);
        int dd = this.pixel().y() + this.height() / 2 - (height - 1);
        int dl = 0 - (this.pixel().x() - this.width() / 2);
        int dr = this.pixel().x() + this.width() / 2 - (width - 1);
        if (dl < 0) {
            if (dr < 0) {
                if (du < 0) {
                    if (dd < 0) {
                        return this.shape().size();
                    }
                    return this.shape().sizeTrunkDown(dd);
                }
                if (dd < 0) {
                    return this.shape().sizeTrunkUp(du);
                }
                return this.shape().sizeTrunkUpDown(du, dd);
            }
            if (du < 0) {
                if (dd < 0) {
                    return this.shape().sizeTrunkRight(dr);
                }
                return this.shape().sizeTrunkDownRight(dd, dr);
            }
            if (dd < 0) {
                return this.shape().sizeTrunkUpRight(du, dr);
            }
            return this.shape().sizeTrunkUpDownRight(du, dd, dr);
        }
        if (dr < 0) {
            if (du < 0) {
                if (dd < 0) {
                    return this.shape().sizeTrunkLeft(dl);
                }
                return this.shape().sizeTrunkDownLeft(dd, dl);
            }
            if (dd < 0) {
                return this.shape().sizeTrunkUpLeft(du, dl);
            }
            return this.shape().sizeTrunkUpDownLeft(du, dd, dl);
        }
        if (du < 0) {
            if (dd < 0) {
                return this.shape().sizeTrunkLeftRight(dl, dr);
            }
            return this.shape().sizeTrunkDownLeftRight(dd, dl, dr);
        }
        if (dd < 0) {
            return this.shape().sizeTrunkUpLeftRight(du, dl, dr);
        }
        return this.shape().sizeTrunkUpDownLeftRight(du, dd, dl, dr);
    }

    @Override
    public List<Pixel> removeDownList() {
        return this.shape().removeDownList();
    }

    @Override
    public List<Pixel> addDownList() {
        return this.shape().addDownList();
    }

    @Override
    public List<Pixel> removeHorizontalDownList() {
        return this.shape().removeHorizontalDownList();
    }

    @Override
    public List<Pixel> addHorizontalDownList() {
        return this.shape().addHorizontalDownList();
    }

    @Override
    public List<Pixel> removeVerticalDownList() {
        return this.shape().removeVerticalDownList();
    }

    @Override
    public List<Pixel> addVerticalDownList() {
        return this.shape().addVerticalDownList();
    }
}

