/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.metric;

import fr.inra.sad.bagap.apiland.analysis.Stats;
import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.HashSet;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class MeanSamePatchCompacityMetric
extends VectorMetric {
    private String attribute;

    public MeanSamePatchCompacityMetric(String attribute) {
        super(VariableManager.get("MSKG"));
        this.attribute = attribute;
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        HashSet<Polygon> patches = new HashSet<Polygon>();
        patches.addAll(polygons);
        while (this.getPatches(patches, t)) {
        }
        Stats stats = new Stats();
        for (Polygon p : patches) {
            stats.add(0.28 * p.getLength() / Math.sqrt(p.getArea()));
        }
        stats.calculate();
        this.value = stats.getAverage();
        if (Double.isNaN(this.value)) {
            this.value = Raster.getNoDataValue();
        }
    }

    private boolean getPatches(Set<Polygon> patches, Instant t) {
        boolean ok = false;
        HashSet<Polygon> temp = new HashSet<Polygon>();
        HashSet<Polygon> ever = new HashSet<Polygon>();
        for (Polygon p1 : patches) {
            if (ever.contains(p1)) continue;
            boolean thisok = false;
            ever.add(p1);
            Object o1 = ((Composition)p1.getUserData()).getAttribute(this.attribute).getValue(t);
            for (Polygon p2 : patches) {
                Object o2 = ((Composition)p2.getUserData()).getAttribute(this.attribute).getValue(t);
                if (ever.contains(p2) || !o1.equals(o2) || !p1.intersects((Geometry)p2)) continue;
                ok = true;
                thisok = true;
                ever.add(p2);
                Polygon p3 = (Polygon)p1.union((Geometry)p2);
                p3.setUserData(p1.getUserData());
                temp.add(p3);
            }
            if (thisok) continue;
            temp.add(p1);
        }
        if (ok) {
            patches.clear();
            patches.addAll(temp);
        }
        return ok;
    }
}

