/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.metric;

import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.HashMap;
import java.util.Set;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ShannonMetric
extends VectorMetric {
    private Set<Object> codes;

    public ShannonMetric(Set<Object> codes) {
        super(VariableManager.get("SHDI"));
        this.codes = codes;
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        HashMap<Object, VectorMetric.Count> areas = new HashMap<Object, VectorMetric.Count>();
        for (Object code : this.codes) {
            areas.put(code, new VectorMetric.Count(this));
        }
        double total = 0.0;
        for (Polygon p : polygons) {
            total += p.getArea();
            Object code = ((Composition)p.getUserData()).getAttribute("cover").getValue(t);
            if (!this.codes.contains(code)) continue;
            ((VectorMetric.Count)areas.get(code)).add(p.getArea());
        }
        this.value = 0.0;
        for (Object c : this.codes) {
            double p = ((VectorMetric.Count)areas.get(c)).get() / total;
            if (p == 0.0) continue;
            this.value += p * Math.log(p);
        }
        if (this.value != 0.0) {
            this.value *= -1.0;
        }
        if (Double.isNaN(this.value)) {
            this.value = Raster.getNoDataValue();
        }
    }
}

