/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.process;

import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.analysis.vector.process.VectorProcessType;
import fr.inra.sad.bagap.apiland.core.element.DynamicFeature;
import fr.inra.sad.bagap.apiland.core.space.Geometry;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.PreparedPolygon;

public class VectorProcess
extends Process<VectorMetric> {
    private Point point;
    private Set<Polygon> polygons;
    private Map<Point, Set<Polygon>> references;

    public VectorProcess(VectorProcessType pt) {
        super(pt);
        this.references = new HashMap<Point, Set<Polygon>>();
    }

    public VectorProcess(Point p, VectorProcessType pt) {
        super(pt);
        this.point = p;
    }

    public void setPoint(Point p) {
        this.point = p;
        this.polygons = this.references.containsKey(p) ? this.references.get(p) : null;
    }

    public double x() {
        return this.point.getCoordinate().x;
    }

    public double y() {
        return this.point.getCoordinate().y;
    }

    public Point point() {
        return this.point;
    }

    @Override
    public int compareTo(Process<VectorMetric> other) {
        if (other instanceof VectorProcess) {
            if (((VectorProcess)other).point.getCoordinate().y > this.point.getCoordinate().y) {
                return -1;
            }
            if (((VectorProcess)other).point.getCoordinate().y < this.point.getCoordinate().y) {
                return 1;
            }
            if (((VectorProcess)other).point.getCoordinate().x > this.point.getCoordinate().x) {
                return -1;
            }
            if (((VectorProcess)other).point.getCoordinate().x < this.point.getCoordinate().x) {
                return 1;
            }
        }
        return 1;
    }

    public VectorProcessType processType() {
        return (VectorProcessType)super.processType();
    }

    public void unCalculate(Set<Double> buffers, Set<VectorMetric> metrics) {
        for (double buffer : buffers) {
            for (VectorMetric vm : metrics) {
                vm.unCalculate(this, buffer + "_");
            }
        }
        this.setState(ProcessState.DONE);
    }

    public void calculate(Set<Double> buffers, Set<VectorMetric> metrics, List<DynamicFeature> features, Instant t) {
        for (double buffer : buffers) {
            this.getBuffer(features, t, this.point, buffer);
            for (VectorMetric vm : metrics) {
                vm.calculate(this, buffer + "_", this.point, this.polygons, t);
            }
            this.polygons = null;
        }
        this.setState(ProcessState.DONE);
    }

    public void calculate(Set<VectorMetric> metrics, List<DynamicFeature> features, Instant t) {
        this.polygons = new HashSet<Polygon>();
        for (DynamicFeature f : features) {
            Polygon fp = (Polygon)((Geometry)f.getDefaultRepresentation().getGeometry(t)).get().getJTS();
            fp.setUserData((Object)f.getComposition());
            this.polygons.add(fp);
        }
        for (VectorMetric vm : metrics) {
            vm.calculate(this, "", this.point, this.polygons, t);
        }
        this.polygons = null;
        this.setState(ProcessState.DONE);
    }

    private void getBuffer(List<DynamicFeature> features, Instant t, Point p, double b) {
        if (this.polygons == null) {
            this.createBuffer(features, t, p, b);
        }
    }

    private void createBuffer(List<DynamicFeature> features, Instant t, Point p, double b) {
        this.polygons = new HashSet<Polygon>();
        Polygon buffer = (Polygon)p.buffer(b);
        PreparedPolygon pp = new PreparedPolygon((Polygonal)buffer);
        for (DynamicFeature f : features) {
            org.locationtech.jts.geom.Geometry fp = ((Geometry)f.getDefaultRepresentation().getGeometry(t)).get().getJTS();
            if (!pp.intersects(fp)) continue;
            if (pp.overlaps(fp)) {
                org.locationtech.jts.geom.Geometry g = buffer.intersection(fp);
                if (g instanceof Polygon) {
                    g.setUserData((Object)f.getComposition());
                    this.polygons.add((Polygon)g);
                    continue;
                }
                if (!(g instanceof MultiPolygon)) continue;
                for (int i = 0; i < ((MultiPolygon)g).getNumGeometries(); ++i) {
                    Polygon gt = (Polygon)((MultiPolygon)g).getGeometryN(i);
                    gt.setUserData((Object)f.getComposition());
                    this.polygons.add(gt);
                }
                continue;
            }
            if (pp.contains(fp)) {
                fp.setUserData((Object)f.getComposition());
                this.polygons.add((Polygon)fp);
                continue;
            }
            if (!pp.within(fp)) continue;
            buffer.setUserData((Object)f.getComposition());
            this.polygons.add(buffer);
            break;
        }
    }
}

