/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.capfarm.model.ConstraintSystemFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverManager;
import fr.inra.sad.bagap.apiland.capfarm.model.GenericConstraintSystem;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.GenericConstraintBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ConstraintFactoryFromExcel {
    private GenericConstraintSystem system;
    private GenericConstraintBuilder builder;
    private String conscode;
    private int iconscode;
    private String date;
    private String codeFarm;
    private String farmer;
    private String farmType;
    private String mail;
    private String address;
    private String tel;
    private int essai;
    private int nbYearHistoric;
    private int nbYearSimulation;
    private int nbSimulation;
    private String output;
    private Map<String, String> genericCovers;
    private List<String> covers;
    private Map<String, Set<String>> groups;
    private List<String> parcelles;
    private Map<String, Set<String>> zones;

    public ConstraintFactoryFromExcel(String path, String input) {
        this.output = path;
        new File(this.output).mkdirs();
        this.integrate(path + input);
    }

    private void integrate(String input) {
        try {
            XSSFWorkbook workbook = new XSSFWorkbook(new File(input));
            this.system = new GenericConstraintSystem("contraintes");
            this.builder = new GenericConstraintBuilder(this.system);
            this.conscode = "CO";
            this.iconscode = 1;
            this.integrateInfos(workbook);
            this.integrateGenericsCovers(workbook);
            this.integrateParcellaire(workbook);
            this.integrateCovers(workbook);
            this.integrateNextCovers(workbook);
            this.integrateGroups(workbook);
            this.integrateConstraints(workbook);
            this.writeInfos();
            this.writeCovers();
            this.writeCoverGroups();
            this.writeConstraints();
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
    }

    private void integrateInfos(XSSFWorkbook workbook) {
        XSSFSheet sheet = workbook.getSheet("infos");
        this.codeFarm = sheet.getRow(0).getCell(1).getStringCellValue();
        this.farmer = sheet.getRow(1).getCell(1).getStringCellValue();
        this.farmType = sheet.getRow(2).getCell(1).getStringCellValue();
        this.mail = sheet.getRow(3).getCell(1).getStringCellValue();
        this.address = sheet.getRow(4).getCell(1).getStringCellValue();
        this.tel = sheet.getRow(5).getCell(1).getStringCellValue();
        this.essai = (int)sheet.getRow(6).getCell(1).getNumericCellValue();
        this.date = sheet.getRow(7).getCell(1).getStringCellValue();
        this.nbYearHistoric = (int)sheet.getRow(8).getCell(1).getNumericCellValue();
        this.nbYearSimulation = (int)sheet.getRow(9).getCell(1).getNumericCellValue();
        this.nbSimulation = (int)sheet.getRow(10).getCell(1).getNumericCellValue();
    }

    private void integrateGenericsCovers(XSSFWorkbook workbook) {
        XSSFSheet sheet = workbook.getSheet("cultures");
        this.genericCovers = new TreeMap<String, String>();
        this.groups = new HashMap<String, Set<String>>();
        for (Row r : sheet) {
            String group;
            if (r.getRowNum() <= 1) continue;
            this.genericCovers.put(r.getCell(1).getStringCellValue(), r.getCell(0).getStringCellValue());
            if (r.getCell(3) == null || (group = r.getCell(3).getStringCellValue()).equalsIgnoreCase("")) continue;
            if (!this.groups.containsKey(group)) {
                this.groups.put(group, new HashSet());
            }
            this.groups.get(group).add(r.getCell(0).getStringCellValue());
        }
    }

    private void integrateCovers(XSSFWorkbook workbook) {
        XSSFSheet sheet = workbook.getSheet("cultures-txt");
        this.covers = new ArrayList<String>();
        for (Row r : sheet) {
            String cover;
            if (r.getRowNum() <= 1 || !this.genericCovers.containsKey(cover = r.getCell(2).getStringCellValue())) continue;
            this.covers.add(cover);
            this.system.addCover(CoverManager.getCoverUnit(this.genericCovers.get(cover), cover));
        }
    }

    private void integrateNextCovers(XSSFWorkbook workbook) {
        XSSFSheet sheet = workbook.getSheet("suivants-txt");
        this.integrateSingleNextCovers(sheet, 1);
        sheet = workbook.getSheet("suivants-2-txt");
        this.integrateSingleNextCovers(sheet, 2);
        sheet = workbook.getSheet("suivants-3-txt");
        this.integrateSingleNextCovers(sheet, 3);
        sheet = workbook.getSheet("suivants-4-txt");
        this.integrateSingleNextCovers(sheet, 4);
        sheet = workbook.getSheet("suivants-5-txt");
        this.integrateSingleNextCovers(sheet, 5);
    }

    private void integrateSingleNextCovers(XSSFSheet sheet, int nb) {
        String location = sheet.getRow(0).getCell(0).getStringCellValue();
        ArrayList<String> mycovers = new ArrayList<String>();
        for (Cell c : sheet.getRow(0)) {
            String cover = c.getStringCellValue();
            if (!this.genericCovers.keySet().contains(cover)) continue;
            mycovers.add(this.genericCovers.get(cover));
        }
        if (mycovers.size() > 0) {
            boolean[][] next = new boolean[mycovers.size()][mycovers.size()];
            for (int j = 0; j < mycovers.size(); ++j) {
                XSSFRow r = sheet.getRow(j + 1);
                for (int i = 0; i < mycovers.size(); ++i) {
                    next[j][i] = new Boolean(r.getCell(i + 1).toString());
                }
            }
            this.writeNextCovers(mycovers, next, location, nb);
            this.builder.setCode(this.conscode + this.iconscode++);
            this.builder.setLocation(location);
            this.builder.setType(ConstraintType.NextCover);
            this.builder.setParams(this.output + "next-" + nb + ".txt");
            this.builder.build();
        }
    }

    private void writeNextCovers(List<String> mycovers, boolean[][] next, String location, int nb) {
        try {
            CsvWriter cw2 = new CsvWriter(this.output + "next-" + nb + ".txt");
            cw2.setDelimiter(';');
            cw2.write("previous");
            for (String cover : mycovers) {
                cw2.write(cover);
            }
            cw2.endRecord();
            for (int j = 0; j < mycovers.size(); ++j) {
                cw2.write(mycovers.get(j));
                for (int i = 0; i < mycovers.size(); ++i) {
                    if (next[j][i]) {
                        cw2.write("1");
                        continue;
                    }
                    cw2.write("0");
                }
                cw2.endRecord();
            }
            cw2.close();
        }
        catch (CsvWriter.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }

    private void integrateGroups(XSSFWorkbook workbook) {
        for (Map.Entry<String, Set<String>> e : this.groups.entrySet()) {
            String mycovers = e.getValue().toString().replaceAll("\\[", "{").replaceAll("\\]", "}").replaceAll(" ", "");
            this.system.addCover(CoverManager.getCoverGroup(e.getKey(), e.getKey(), mycovers));
        }
    }

    private void integrateParcellaire(XSSFWorkbook workbook) {
        XSSFSheet sheet = workbook.getSheet("parcellaire");
        HashMap<String, Integer> entetes = new HashMap<String, Integer>();
        int i = 0;
        for (Object c : sheet.getRow(0)) {
            String string = c.getStringCellValue();
            if (!string.equalsIgnoreCase("")) {
                entetes.put(string, i);
            }
            ++i;
        }
        this.zones = new HashMap<String, Set<String>>();
        for (Map.Entry entry : entetes.entrySet()) {
            boolean zonage = true;
            for (Row r : sheet) {
                String v;
                if (r.getRowNum() <= 0 || (v = r.getCell(((Integer)entry.getValue()).intValue()).toString()).equalsIgnoreCase("0.0") || v.equalsIgnoreCase("1.0")) continue;
                zonage = false;
                break;
            }
            if (!zonage) continue;
            this.zones.put((String)entry.getKey(), new HashSet());
        }
        if (entetes.containsKey("id")) {
            this.parcelles = new ArrayList<String>();
            HashSet links = new HashSet();
            for (Row row : sheet) {
                if (row.getRowNum() <= 0) continue;
                String parcelle = row.getCell(((Integer)entetes.get("id")).intValue()).getStringCellValue();
                this.parcelles.add(parcelle);
                for (String string : this.zones.keySet()) {
                    if (!row.getCell(((Integer)entetes.get(string)).intValue()).toString().equalsIgnoreCase("1.0")) continue;
                    this.zones.get(string).add(parcelle);
                }
                if (!entetes.containsKey("parcellink") || row.getCell(((Integer)entetes.get("parcellink")).intValue()).toString().equalsIgnoreCase("")) continue;
                boolean ever = false;
                for (Set l : links) {
                    if (!l.contains(parcelle)) continue;
                    ever = true;
                    break;
                }
                if (ever) continue;
                String[] stringArray = row.getCell(((Integer)entetes.get("parcellink")).intValue()).toString().split(",");
                HashSet<String> link = new HashSet<String>();
                link.add(parcelle);
                for (String s : stringArray) {
                    link.add(s.replace(".0", ""));
                }
                links.add(link);
            }
            for (Set set : links) {
                this.builder.setCode(this.conscode + this.iconscode++);
                this.builder.setLocation(set.toString().replace(" ", ""));
                this.builder.setType(ConstraintType.LinkedFields);
                this.builder.build();
            }
        }
    }

    private void integrateConstraints(XSSFWorkbook workbook) {
        XSSFSheet sheet = workbook.getSheet("contraintes");
        HashMap<String, Integer> entetes = new HashMap<String, Integer>();
        int i = 0;
        for (Cell c : sheet.getRow(0)) {
            String entete = c.getStringCellValue();
            if (!entete.equalsIgnoreCase("")) {
                entetes.put(entete, i);
            }
            ++i;
        }
        for (Row r : sheet) {
            if (r.getRowNum() <= 0) continue;
            String culture = r.getCell(0).getStringCellValue();
            if (culture.equalsIgnoreCase("")) break;
            String parcelles = r.getCell(((Integer)entetes.get("parcelles")).intValue()).getStringCellValue();
            boolean locationConstraint = true;
            String delai_min = r.getCell(((Integer)entetes.get("delai_min")).intValue()).toString();
            String delai_max = r.getCell(((Integer)entetes.get("delai_max")).intValue()).toString();
            if (!delai_min.equalsIgnoreCase("") || !delai_max.equalsIgnoreCase("")) {
                this.builder.setCode(this.conscode + this.iconscode++);
                this.builder.setLocation(parcelles);
                if (this.genericCovers.get(culture) == null) {
                    this.builder.setCover(culture);
                    this.builder.setParams(culture);
                } else {
                    this.builder.setCover(this.genericCovers.get(culture));
                    this.builder.setParams(this.genericCovers.get(culture));
                }
                this.builder.setType(ConstraintType.Delay);
                this.builder.setDomain("[" + delai_min + "," + delai_max + "]");
                this.builder.build();
                locationConstraint = false;
            }
            String repetition_min = r.getCell(((Integer)entetes.get("repetition_min")).intValue()).toString();
            String repetition_max = r.getCell(((Integer)entetes.get("repetition_max")).intValue()).toString();
            String repetition_repart = r.getCell(((Integer)entetes.get("repetition_repart")).intValue()).toString();
            if (repetition_repart.equalsIgnoreCase("")) {
                repetition_repart = "middle";
            }
            if (!repetition_min.equalsIgnoreCase("") || !repetition_max.equalsIgnoreCase("")) {
                this.builder.setCode(this.conscode + this.iconscode++);
                this.builder.setLocation(parcelles);
                if (this.genericCovers.get(culture) == null) {
                    this.builder.setCover(culture);
                } else {
                    this.builder.setCover(this.genericCovers.get(culture));
                }
                this.builder.setType(ConstraintType.Repetition);
                this.builder.setDomain("[" + repetition_min + "," + repetition_max + "]");
                this.builder.setParams(repetition_repart);
                this.builder.build();
                locationConstraint = false;
            }
            String duree_min = r.getCell(((Integer)entetes.get("duree_min")).intValue()).toString();
            String duree_max = r.getCell(((Integer)entetes.get("duree_max")).intValue()).toString();
            String duree_repart = r.getCell(((Integer)entetes.get("duree_repart")).intValue()).toString();
            if (duree_repart.equalsIgnoreCase("")) {
                duree_repart = "middle";
            }
            if (!duree_min.equalsIgnoreCase("") || !duree_max.equalsIgnoreCase("")) {
                this.builder.setCode(this.conscode + this.iconscode++);
                this.builder.setLocation(parcelles);
                if (this.genericCovers.get(culture) == null) {
                    this.builder.setCover(culture);
                } else {
                    this.builder.setCover(this.genericCovers.get(culture));
                }
                this.builder.setType(ConstraintType.Duration);
                this.builder.setDomain("[" + duree_min + "," + duree_max + "]");
                this.builder.setParams(duree_repart);
                this.builder.build();
                locationConstraint = false;
            }
            String aire_min = r.getCell(((Integer)entetes.get("aire_min")).intValue()).toString();
            String aire_max = r.getCell(((Integer)entetes.get("aire_max")).intValue()).toString();
            if (!aire_min.equalsIgnoreCase("") || !aire_max.equalsIgnoreCase("")) {
                this.builder.setCode(this.conscode + this.iconscode++);
                this.builder.setLocation(parcelles);
                if (this.genericCovers.get(culture) == null) {
                    this.builder.setCover(culture);
                } else {
                    this.builder.setCover(this.genericCovers.get(culture));
                }
                this.builder.setType(ConstraintType.TotalArea);
                this.builder.setDomain("[" + aire_min + "," + aire_max + "]");
                this.builder.build();
                locationConstraint = false;
            }
            String distance_siege_min = r.getCell(((Integer)entetes.get("distance_siege_min")).intValue()).toString();
            String distance_siege_max = r.getCell(((Integer)entetes.get("distance_siege_max")).intValue()).toString();
            if (!distance_siege_min.equalsIgnoreCase("") || !distance_siege_max.equalsIgnoreCase("")) {
                this.builder.setCode(this.conscode + this.iconscode++);
                this.builder.setLocation(parcelles);
                if (this.genericCovers.get(culture) == null) {
                    this.builder.setCover(culture);
                } else {
                    this.builder.setCover(this.genericCovers.get(culture));
                }
                this.builder.setType(ConstraintType.DistanceFromFacilities);
                this.builder.setDomain("[" + distance_siege_min + "," + distance_siege_max + "]");
                this.builder.setParams("siege");
                this.builder.build();
                locationConstraint = false;
            }
            String surface_parcelle_min = r.getCell(((Integer)entetes.get("surface_parcelle_min")).intValue()).toString();
            String surface_parcelle_max = r.getCell(((Integer)entetes.get("surface_parcelle_max")).intValue()).toString();
            if (!surface_parcelle_min.equalsIgnoreCase("") || !surface_parcelle_max.equalsIgnoreCase("")) {
                this.builder.setCode(this.conscode + this.iconscode++);
                this.builder.setLocation(parcelles);
                if (this.genericCovers.get(culture) == null) {
                    this.builder.setCover(culture);
                } else {
                    this.builder.setCover(this.genericCovers.get(culture));
                }
                this.builder.setType(ConstraintType.ParcelArea);
                this.builder.setDomain("[" + surface_parcelle_min + "," + surface_parcelle_max + "]");
                this.builder.build();
                locationConstraint = false;
            }
            String distance_entre_couverts_min = r.getCell(((Integer)entetes.get("distance_entre_couverts_min")).intValue()).toString();
            String distance_entre_couverts_max = r.getCell(((Integer)entetes.get("distance_entre_couverts_max")).intValue()).toString();
            if (!distance_entre_couverts_min.equalsIgnoreCase("") || !distance_entre_couverts_max.equalsIgnoreCase("")) {
                this.builder.setCode(this.conscode + this.iconscode++);
                this.builder.setLocation(parcelles);
                if (this.genericCovers.get(culture) == null) {
                    this.builder.setCover(culture);
                    this.builder.setParams(culture);
                } else {
                    this.builder.setCover(this.genericCovers.get(culture));
                    this.builder.setParams(this.genericCovers.get(culture));
                }
                this.builder.setType(ConstraintType.DistanceBetweenCovers);
                this.builder.setDomain("[" + distance_entre_couverts_min + "," + distance_entre_couverts_max + "]");
                this.builder.build();
                locationConstraint = false;
            }
            if (!locationConstraint) continue;
            this.builder.setCode(this.conscode + this.iconscode++);
            this.builder.setLocation(parcelles);
            if (this.genericCovers.get(culture) == null) {
                this.builder.setCover(culture);
            } else {
                this.builder.setCover(this.genericCovers.get(culture));
            }
            this.builder.setType(ConstraintType.OnLocation);
            this.builder.build();
        }
    }

    private void writeInfos() {
        try {
            Properties properties = new Properties();
            properties.setProperty("date", this.date);
            properties.setProperty("code", this.codeFarm);
            properties.setProperty("exploitant", this.farmer);
            properties.setProperty("type_exploitation", this.farmType);
            properties.setProperty("mail", this.mail);
            properties.setProperty("adresse", this.address);
            properties.setProperty("tel", this.tel);
            properties.setProperty("version", this.essai + "");
            properties.setProperty("nb_annees_historique", this.nbYearHistoric + "");
            properties.setProperty("nb_annees_simulations", this.nbYearSimulation + "");
            properties.setProperty("nb_simulations", this.nbSimulation + "");
            FileOutputStream out = new FileOutputStream(this.output + "infos.txt");
            properties.store(out, "info file generated with CAPFarm");
            out.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void writeCovers() {
        CoverFactory.exportCoverUnits(this.output + "covers.txt");
    }

    private void writeCoverGroups() {
        CoverFactory.exportCoverGroups(this.output + "groups.txt");
    }

    private void writeConstraints() {
        ConstraintSystemFactory.exportSystem(this.system, this.output + "contraintes_" + this.codeFarm + "_" + this.essai + ".csv");
    }
}

