/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model;

import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CoverManager {
    private static Map<String, CoverUnit> coverUnits = new TreeMap<String, CoverUnit>();
    private static Map<String, CoverGroup> coverGroups = new TreeMap<String, CoverGroup>();

    public static boolean hasCover(String code) {
        return coverUnits.containsKey(code) || coverGroups.containsKey(code);
    }

    public static Cover getCover(String code) {
        if (coverUnits.containsKey(code)) {
            return coverUnits.get(code);
        }
        return coverGroups.get(code);
    }

    public static CoverUnit getCoverUnit(String code) {
        return coverUnits.get(code);
    }

    public static int getCoverIndex(String code) {
        int i = 1;
        for (String kc : coverUnits.keySet()) {
            if (kc.equalsIgnoreCase(code)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public static CoverUnit getCoverUnit(String code, String name) {
        if (!coverUnits.containsKey(code)) {
            CoverUnit cu = new CoverUnit(code, name);
            coverUnits.put(code, cu);
        }
        return coverUnits.get(code);
    }

    public static Cover getCoverGroup(String code, String name, String covers) {
        if (!coverGroups.containsKey(code)) {
            CoverGroup cg = new CoverGroup(code, name, CoverManager.initCovers(covers));
            coverGroups.put(code, cg);
        }
        for (String c : covers.replace("{", "").replace("}", "").split(",")) {
            if (coverGroups.get(code).contains(c)) continue;
            coverGroups.get(code).add(CoverManager.getCoverUnit(c));
        }
        return coverGroups.get(code);
    }

    private static Set<CoverUnit> initCovers(String covers) {
        String[] cc;
        TreeSet<CoverUnit> group = new TreeSet<CoverUnit>();
        for (String c : cc = covers.replace("{", "").replace("}", "").split(",")) {
            if (c.equalsIgnoreCase("")) continue;
            group.add(CoverManager.getCoverUnit(c));
        }
        return group;
    }

    public static Set<CoverUnit> coverUnits() {
        TreeSet<CoverUnit> cu = new TreeSet<CoverUnit>();
        for (Map.Entry<String, CoverUnit> e : coverUnits.entrySet()) {
            cu.add(e.getValue());
        }
        return cu;
    }

    public static Set<CoverGroup> coverGroups() {
        TreeSet<CoverGroup> cg = new TreeSet<CoverGroup>();
        for (Map.Entry<String, CoverGroup> e : coverGroups.entrySet()) {
            cg.add(e.getValue());
        }
        return cg;
    }

    public static void display() {
        System.out.println();
        for (Map.Entry<String, CoverUnit> entry : coverUnits.entrySet()) {
            System.out.println(entry.getKey() + " " + entry.getValue());
        }
        for (Map.Entry<String, Cover> entry : coverGroups.entrySet()) {
            System.out.println(entry.getKey() + " " + entry.getValue());
        }
    }
}

