/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public abstract class CoverAllocationConstraint<D, E>
implements Serializable,
Comparable<CoverAllocationConstraint<?, ?>> {
    private static final long serialVersionUID = 1L;
    private CoverAllocator ca;
    private String code;
    private Set<CoverUnit> covers;
    private Set<Parcel> location;
    private ConstraintType type;
    private ConstraintMode mode;
    private Domain<D, E> domain;
    private boolean checkOnly = false;

    public CoverAllocationConstraint(String code, boolean checkOnly, ConstraintType type, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels, Domain<D, E> domain) {
        this.code = code;
        this.checkOnly = checkOnly;
        this.type = type;
        this.mode = mode;
        this.covers = this.getCoverUnits(covers);
        this.location = new HashSet<Parcel>();
        this.location.addAll(parcels);
        this.domain = domain;
    }

    public void setCheckOnly(boolean checkOnly) {
        this.checkOnly = checkOnly;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Cover cover : this.covers) {
            sb.append(cover.getCode() + ", ");
        }
        String covs = sb.substring(0, sb.length() - 2);
        StringBuilder stringBuilder = new StringBuilder();
        for (Parcel p : this.location) {
            stringBuilder.append(p + ", ");
        }
        String parcels = null;
        if (stringBuilder.length() > 0) {
            parcels = stringBuilder.substring(0, stringBuilder.length() - 2);
        }
        return "constraint '" + this.code + "' for " + covs + " : " + (Object)((Object)this.type) + " " + (Object)((Object)this.mode) + " in domain " + this.domain;
    }

    public boolean equals(Object o) {
        if (o instanceof CoverAllocationConstraint) {
            return this.code.equals(((CoverAllocationConstraint)o).code);
        }
        return false;
    }

    public String code() {
        return this.code;
    }

    public boolean checkOnly() {
        return this.checkOnly;
    }

    public ConstraintType type() {
        return this.type;
    }

    public ConstraintMode mode() {
        return this.mode;
    }

    public Set<CoverUnit> covers() {
        return this.covers;
    }

    public boolean hasSingleCover() {
        return this.covers().size() == 1;
    }

    public CoverUnit getSingleCover() {
        return this.covers.iterator().next();
    }

    protected Set<CoverUnit> getCoverUnits(Set<Cover> covers) {
        HashSet<CoverUnit> coverunits = new HashSet<CoverUnit>();
        for (Cover c : covers) {
            if (c instanceof CoverUnit) {
                coverunits.add((CoverUnit)c);
                continue;
            }
            for (CoverUnit cu : (CoverGroup)c) {
                coverunits.add(cu);
            }
        }
        return coverunits;
    }

    public Set<Parcel> location() {
        return this.location;
    }

    public Domain<D, E> domain() {
        return this.domain;
    }

    public abstract void post(CoverAllocationProblem var1);

    public boolean check(Instant start, Instant end, boolean verbose) {
        return false;
    }

    @Override
    public int compareTo(CoverAllocationConstraint<?, ?> o) {
        return this.code.compareTo(o.code);
    }

    public void setAllocator(CoverAllocator ca) {
        this.ca = ca;
    }

    public CoverAllocator getAllocator() {
        return this.ca;
    }
}

