/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import fr.inra.sad.bagap.apiland.core.time.delay.YearDelay;
import java.util.Set;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.LCF;
import org.chocosolver.solver.variables.IntVar;

public class DistanceFromFacilitiesConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;
    private String facilities;

    public DistanceFromFacilitiesConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> location, Domain<Integer, Integer> domain, String facilities) {
        super(code, checkOnly, ConstraintType.DistanceFromFacilities, mode, covers, location, domain);
        this.facilities = facilities;
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        if (this.hasSingleCover()) {
            CoverUnit c = this.getSingleCover();
            int ic = cap.covers().get(c);
            for (Parcel p : this.location()) {
                int ip = cap.parcels().get(p);
                int distance = cap.allocator().getDistanceFromFacilitiesToParcel(this.facilities, p);
                if (distance == -1) continue;
                switch (this.mode()) {
                    case ALWAYS: {
                        if (!this.domain().accept(distance)) break;
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1));
                        break;
                    }
                    case NEVER: {
                        if (!this.domain().accept(distance)) break;
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                        break;
                    }
                    case AROUND: {
                        if (this.domain().accept(distance)) break;
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1));
                        break;
                    }
                    case ONLY: {
                        if (this.domain().accept(distance)) break;
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                    }
                }
            }
        } else {
            block13: for (Parcel p : this.location()) {
                int ip = cap.parcels().get(p);
                int distance = cap.allocator().getDistanceFromFacilitiesToParcel(this.facilities, p);
                if (distance == -1) continue;
                switch (this.mode()) {
                    case ALWAYS: {
                        int ic;
                        if (!this.domain().accept(distance)) break;
                        Constraint[] ct = new Constraint[this.covers().size()];
                        int i = 0;
                        for (CoverUnit c : this.covers()) {
                            ic = cap.covers().get(c);
                            ct[i++] = ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1);
                        }
                        cap.solver().post(LCF.or((Constraint[])ct));
                        break;
                    }
                    case NEVER: {
                        if (!this.domain().accept(distance)) break;
                        for (CoverUnit c : this.covers()) {
                            int ic = cap.covers().get(c);
                            cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                        }
                        continue block13;
                    }
                    case AROUND: {
                        int ic;
                        if (this.domain().accept(distance)) break;
                        Constraint[] ct = new Constraint[this.covers().size()];
                        int i = 0;
                        for (CoverUnit c : this.covers()) {
                            ic = cap.covers().get(c);
                            ct[i++] = ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1);
                        }
                        cap.solver().post(LCF.or((Constraint[])ct));
                        break;
                    }
                    case ONLY: {
                        if (this.domain().accept(distance)) break;
                        for (CoverUnit c : this.covers()) {
                            int ic = cap.covers().get(c);
                            cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0));
                        }
                        break;
                    }
                }
            }
        }
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        sb.append("distance from facilities ");
        YearDelay d = new YearDelay(1);
        switch (this.mode()) {
            case ALWAYS: {
                for (Parcel p : this.location()) {
                    int distance = this.getAllocator().getDistanceFromFacilitiesToParcel(this.facilities, p);
                    if (!this.domain().accept(distance)) continue;
                    Instant t = start;
                    while (t.isBefore(end) || t.equals(end)) {
                        Cover c = (Cover)p.getAttribute("cover").getValue(t);
                        if (!this.covers().contains(c)) {
                            ok = false;
                            if (verbose) {
                                sb.append("BAD Distance " + (Object)((Object)this.mode()) + " : parcel " + p.getId() + " area = " + p.getArea() + " not in domain " + this.domain() + "\n");
                            } else {
                                return ok;
                            }
                        }
                        t = ((Delay)d).next(t);
                    }
                }
                break;
            }
            case NEVER: {
                for (Parcel p : this.location()) {
                    int distance = this.getAllocator().getDistanceFromFacilitiesToParcel(this.facilities, p);
                    if (!this.domain().accept(distance)) continue;
                    Instant t = start;
                    while (t.isBefore(end) || t.equals(end)) {
                        Cover c = (Cover)p.getAttribute("cover").getValue(t);
                        if (this.covers().contains(c)) {
                            ok = false;
                            if (verbose) {
                                sb.append("BAD Distance " + (Object)((Object)this.mode()) + " : parcel " + p.getId() + " area = " + p.getArea() + " not in domain " + this.domain() + "\n");
                            } else {
                                return ok;
                            }
                        }
                        t = ((Delay)d).next(t);
                    }
                }
                break;
            }
            case ONLY: {
                for (Parcel p : this.location()) {
                    int distance = this.getAllocator().getDistanceFromFacilitiesToParcel(this.facilities, p);
                    if (this.domain().accept(distance)) continue;
                    Instant t = start;
                    while (t.isBefore(end) || t.equals(end)) {
                        Cover c = (Cover)p.getAttribute("cover").getValue(t);
                        if (this.covers().contains(c)) {
                            ok = false;
                            if (verbose) {
                                sb.append("BAD Distance " + (Object)((Object)this.mode()) + " : parcel " + p.getId() + " area = " + p.getArea() + " not in domain " + this.domain() + "\n");
                            } else {
                                return ok;
                            }
                        }
                        t = ((Delay)d).next(t);
                    }
                }
                break;
            }
            case AROUND: {
                for (Parcel p : this.location()) {
                    int distance = this.getAllocator().getDistanceFromFacilitiesToParcel(this.facilities, p);
                    if (this.domain().accept(distance)) continue;
                    Instant t = start;
                    while (t.isBefore(end) || t.equals(end)) {
                        Cover c = (Cover)p.getAttribute("cover").getValue(t);
                        if (!this.covers().contains(c)) {
                            ok = false;
                            if (verbose) {
                                sb.append("BAD Distance " + (Object)((Object)this.mode()) + " : parcel " + p.getId() + " area = " + p.getArea() + " not in domain " + this.domain() + "\n");
                            } else {
                                return ok;
                            }
                        }
                        t = ((Delay)d).next(t);
                    }
                }
                break;
            }
        }
        if (verbose) {
            System.out.println(sb.toString());
        }
        return ok;
    }
}

